﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront/CloudFront_EXPORTS.h>
#include <aws/cloudfront/model/EncryptionEntities.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace CloudFront {
namespace Model {

/**
 * <p>The field-level encryption profile summary.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/FieldLevelEncryptionProfileSummary">AWS
 * API Reference</a></p>
 */
class FieldLevelEncryptionProfileSummary {
 public:
  AWS_CLOUDFRONT_API FieldLevelEncryptionProfileSummary() = default;
  AWS_CLOUDFRONT_API FieldLevelEncryptionProfileSummary(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_CLOUDFRONT_API FieldLevelEncryptionProfileSummary& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_CLOUDFRONT_API void AddToNode(Aws::Utils::Xml::XmlNode& parentNode) const;

  ///@{
  /**
   * <p>ID for the field-level encryption profile summary.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  FieldLevelEncryptionProfileSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the field-level encryption profile summary was last
   * updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  FieldLevelEncryptionProfileSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Name for the field-level encryption profile summary.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  FieldLevelEncryptionProfileSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A complex data type of encryption entities for the field-level encryption
   * profile that include the public key ID, provider, and field patterns for
   * specifying which fields to encrypt with this key.</p>
   */
  inline const EncryptionEntities& GetEncryptionEntities() const { return m_encryptionEntities; }
  inline bool EncryptionEntitiesHasBeenSet() const { return m_encryptionEntitiesHasBeenSet; }
  template <typename EncryptionEntitiesT = EncryptionEntities>
  void SetEncryptionEntities(EncryptionEntitiesT&& value) {
    m_encryptionEntitiesHasBeenSet = true;
    m_encryptionEntities = std::forward<EncryptionEntitiesT>(value);
  }
  template <typename EncryptionEntitiesT = EncryptionEntities>
  FieldLevelEncryptionProfileSummary& WithEncryptionEntities(EncryptionEntitiesT&& value) {
    SetEncryptionEntities(std::forward<EncryptionEntitiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional comment for the field-level encryption profile summary. The
   * comment cannot be longer than 128 characters.</p>
   */
  inline const Aws::String& GetComment() const { return m_comment; }
  inline bool CommentHasBeenSet() const { return m_commentHasBeenSet; }
  template <typename CommentT = Aws::String>
  void SetComment(CommentT&& value) {
    m_commentHasBeenSet = true;
    m_comment = std::forward<CommentT>(value);
  }
  template <typename CommentT = Aws::String>
  FieldLevelEncryptionProfileSummary& WithComment(CommentT&& value) {
    SetComment(std::forward<CommentT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::String m_name;

  EncryptionEntities m_encryptionEntities;

  Aws::String m_comment;
  bool m_idHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_encryptionEntitiesHasBeenSet = false;
  bool m_commentHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
