/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.ui.RutaImages;
import org.apache.uima.ruta.ide.ui.wizards.RutaProjectWizardFirstPage;
import org.apache.uima.ruta.ide.ui.wizards.RutaProjectWizardSecondPage;
import org.apache.uima.ruta.ide.ui.wizards.RutaWizardMessages;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.ProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.xml.sax.SAXException;

public class RutaProjectCreationWizard
extends ProjectWizard {
    public static final String ID_WIZARD = "org.apache.uima.ruta.ide.ui.wizards.RutaProjectWizard";
    private ProjectWizardFirstPage fFirstPage;
    private ProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public RutaProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(RutaImages.DESC_WIZBAN_PROJECT_CREATION);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(RutaWizardMessages.ProjectCreationWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new RutaProjectWizardFirstPage();
        this.fFirstPage.setTitle(RutaWizardMessages.ProjectCreationWizardFirstPage_title);
        this.fFirstPage.setDescription(RutaWizardMessages.ProjectCreationWizardFirstPage_description);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new RutaProjectWizardSecondPage(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        super.finishPage(monitor);
        this.createProject(monitor);
    }

    public void createProject(IProgressMonitor monitor) throws CoreException {
        IScriptProject scriptProject = this.fSecondPage.getScriptProject();
        RutaProjectCreationWizard.createRutaProject(scriptProject, this.fSecondPage.getRawBuildPath(), monitor);
    }

    public static void createRutaProject(IScriptProject scriptProject, IBuildpathEntry[] buildPath, IProgressMonitor monitor) throws CoreException {
        IFolder utilsFolder;
        IFolder rsrcFolder;
        IFolder srcFolder;
        IFolder descFolder;
        IProject project = scriptProject.getProject();
        IFolder folder = project.getFolder(RutaProjectUtils.getDefaultInputLocation());
        if (!folder.exists()) {
            CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!(folder = project.getFolder(RutaProjectUtils.getDefaultOutputLocation())).exists()) {
            CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!(folder = project.getFolder(RutaProjectUtils.getDefaultTestLocation())).exists()) {
            CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!(descFolder = project.getFolder(RutaProjectUtils.getDefaultDescriptorLocation())).exists()) {
            CoreUtility.createFolder((IFolder)descFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!(srcFolder = project.getFolder(RutaProjectUtils.getDefaultScriptLocation())).exists()) {
            CoreUtility.createFolder((IFolder)srcFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!(rsrcFolder = project.getFolder(RutaProjectUtils.getDefaultResourcesLocation())).exists()) {
            CoreUtility.createFolder((IFolder)rsrcFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!(utilsFolder = descFolder.getFolder("utils")).exists()) {
            CoreUtility.createFolder((IFolder)utilsFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        ArrayList<BPListElement> buildpathEntries = new ArrayList<BPListElement>();
        if (buildPath != null) {
            for (IBuildpathEntry buildpathEntry : buildPath) {
                BPListElement createFromExisting = BPListElement.createFromExisting((IBuildpathEntry)buildpathEntry, (IScriptProject)scriptProject);
                if (createFromExisting.getBuildpathEntry().getEntryKind() == 3) continue;
                buildpathEntries.add(createFromExisting);
            }
        }
        IBuildpathAttribute[] extraAttributes = new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"ruta", (String)"script")};
        IBuildpathEntry newSourceEntry = DLTKCore.newSourceEntry((IPath)srcFolder.getFullPath(), (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (IBuildpathAttribute[])extraAttributes);
        buildpathEntries.add(BPListElement.createFromExisting((IBuildpathEntry)newSourceEntry, (IScriptProject)scriptProject));
        extraAttributes = new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"ruta", (String)"descriptor")};
        IBuildpathEntry newDescriptorEntry = DLTKCore.newSourceEntry((IPath)descFolder.getFullPath(), (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (IBuildpathAttribute[])extraAttributes);
        buildpathEntries.add(BPListElement.createFromExisting((IBuildpathEntry)newDescriptorEntry, (IScriptProject)scriptProject));
        extraAttributes = new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"ruta", (String)"resources")};
        IBuildpathEntry newResourcesEntry = DLTKCore.newSourceEntry((IPath)rsrcFolder.getFullPath(), (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (IBuildpathAttribute[])extraAttributes);
        buildpathEntries.add(BPListElement.createFromExisting((IBuildpathEntry)newResourcesEntry, (IScriptProject)scriptProject));
        BuildpathsBlock.flush(buildpathEntries, (IScriptProject)scriptProject, (IProgressMonitor)monitor);
        RutaProjectCreationWizard.copyDescriptors(descFolder);
        RutaProjectUtils.addProjectDataPath((IProject)project, (IFolder)descFolder);
        descFolder.refreshLocal(2, monitor);
    }

    public static void copyDescriptors(IFolder descFolder) {
        File descDir = descFolder.getLocation().toFile();
        File utilsDir = new File(descFolder.getLocation().toFile(), "utils/");
        utilsDir.mkdirs();
        RutaProjectCreationWizard.copy(descDir, "BasicTypeSystem.xml");
        RutaProjectCreationWizard.copy(descDir, "RutaBasicTypeSystem.xml");
        RutaProjectCreationWizard.copy(descDir, "RutaInternalTypeSystem.xml");
        RutaProjectCreationWizard.copy(descDir, "DefaultSeederTypeSystem.xml");
        RutaProjectCreationWizard.copy(descDir, "BasicEngine.xml");
        RutaProjectCreationWizard.copy(utilsDir, "Modifier.xml");
        RutaProjectCreationWizard.copy(utilsDir, "AnnotationWriter.xml");
        RutaProjectCreationWizard.copy(utilsDir, "StyleMapCreator.xml");
        RutaProjectCreationWizard.copy(utilsDir, "XMIWriter.xml");
        RutaProjectCreationWizard.copy(utilsDir, "SourceDocumentInformation.xml");
        RutaProjectCreationWizard.copy(utilsDir, "PlainTextAnnotator.xml");
        RutaProjectCreationWizard.copy(utilsDir, "PlainTextTypeSystem.xml");
        RutaProjectCreationWizard.copy(utilsDir, "HtmlAnnotator.xml");
        RutaProjectCreationWizard.copy(utilsDir, "HtmlTypeSystem.xml");
        RutaProjectCreationWizard.copy(utilsDir, "HtmlConverter.xml");
        RutaProjectCreationWizard.copy(utilsDir, "Cutter.xml");
        RutaProjectCreationWizard.copy(utilsDir, "ViewWriter.xml");
        RutaProjectCreationWizard.setImportsByLocation(descDir, "BasicEngine.xml");
        RutaProjectCreationWizard.setImportsByLocation(utilsDir, "HtmlAnnotator.xml");
        RutaProjectCreationWizard.setImportsByLocation(utilsDir, "PlainTextAnnotator.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setImportsByLocation(File dir, String descName) {
        FileOutputStream fos = null;
        try {
            Import[] imports;
            File file = new File(dir, descName);
            AnalysisEngineDescription description = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(file));
            for (Import each : imports = description.getAnalysisEngineMetaData().getTypeSystem().getImports()) {
                String name = each.getName();
                String[] split = name.split("[.]");
                String location = split[split.length - 1] + ".xml";
                each.setName(null);
                each.setLocation(location);
            }
            fos = new FileOutputStream(file);
            description.toXML((OutputStream)fos);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        catch (IOException | InvalidXMLException | SAXException e) {
            RutaIdeUIPlugin.error(e);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    private static void copy(File dir, String fileName) {
        InputStream in = null;
        FileOutputStream out = null;
        in = RutaEngine.class.getResourceAsStream(fileName);
        try {
            out = new FileOutputStream(new File(dir, fileName));
        }
        catch (FileNotFoundException e) {
            DLTKCore.error((Throwable)e);
        }
        if (in != null && out != null) {
            RutaProjectCreationWizard.copy(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream fis, OutputStream fos) {
        try {
            int len;
            byte[] buffer = new byte[65535];
            while ((len = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            DLTKCore.error((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    DLTKCore.error((Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    DLTKCore.error((Throwable)e);
                }
            }
        }
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getScriptProject().getProject());
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public String getScriptNature() {
        return "org.apache.uima.ruta.ide.nature";
    }
}

