/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.xbean.naming.context.AbstractContext;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextUtil;
import org.apache.xbean.naming.reference.CachingReference;

public class ImmutableContext
extends AbstractContext {
    private final Map<String, Object> localBindings;
    private final Map<String, Object> absoluteIndex;

    public ImmutableContext(Map<String, Object> bindings) throws NamingException {
        this("", bindings, true);
    }

    public ImmutableContext(Map<String, Object> bindings, boolean cacheReferences) throws NamingException {
        this("", bindings, cacheReferences);
    }

    public ImmutableContext(String nameInNamespace, Map<String, Object> bindings, boolean cacheReferences) throws NamingException {
        super(nameInNamespace, ContextAccess.UNMODIFIABLE);
        if (cacheReferences) {
            bindings = CachingReference.wrapReferences(bindings, this);
        }
        Map<String, Object> localBindings = ContextUtil.createBindings(bindings, this);
        this.localBindings = Collections.unmodifiableMap(localBindings);
        Map<String, Object> globalBindings = ImmutableContext.buildAbsoluteIndex("", localBindings);
        this.absoluteIndex = Collections.unmodifiableMap(globalBindings);
    }

    private static Map<String, Object> buildAbsoluteIndex(String nameInNamespace, Map<String, Object> bindings) {
        String path = nameInNamespace;
        if (path.length() > 0) {
            path = path + "/";
        }
        HashMap<String, Object> globalBindings = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof NestedImmutableContext) {
                NestedImmutableContext nestedContext = (NestedImmutableContext)value;
                globalBindings.putAll(ImmutableContext.buildAbsoluteIndex(nestedContext.getNameInNamespace(), nestedContext.localBindings));
            }
            globalBindings.put(path + name, value);
        }
        return globalBindings;
    }

    @Override
    protected Object getDeepBinding(String name) {
        return this.absoluteIndex.get(name);
    }

    @Override
    protected Map<String, Object> getBindings() {
        return this.localBindings;
    }

    protected final void addDeepBinding(String name, Object value, boolean createIntermediateContexts) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    @Override
    protected final boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    @Override
    protected final void removeDeepBinding(Name name, boolean pruneEmptyContexts) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    @Override
    protected final boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    @Override
    public boolean isNestedSubcontext(Object value) {
        if (value instanceof NestedImmutableContext) {
            NestedImmutableContext context = (NestedImmutableContext)value;
            return this == context.getImmutableContext();
        }
        return false;
    }

    public Context createNestedSubcontext(String path, Map bindings) {
        return new NestedImmutableContext(path, bindings);
    }

    public final class NestedImmutableContext
    extends AbstractContext {
        private final Map<String, Object> localBindings;
        private final String pathWithSlash;

        public NestedImmutableContext(String path, Map<String, Object> bindings) {
            super(ImmutableContext.this.getNameInNamespace(path), ContextAccess.UNMODIFIABLE);
            path = this.getNameInNamespace();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.pathWithSlash = path;
            this.localBindings = Collections.unmodifiableMap(bindings);
        }

        @Override
        protected Object getDeepBinding(String name) {
            String absoluteName = this.pathWithSlash + name;
            return ImmutableContext.this.absoluteIndex.get(absoluteName);
        }

        @Override
        protected Map<String, Object> getBindings() {
            return this.localBindings;
        }

        protected final void addDeepBinding(String name, Object value, boolean createIntermediateContexts) throws NamingException {
            throw new OperationNotSupportedException("Context is immutable");
        }

        @Override
        protected final boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
            throw new OperationNotSupportedException("Context is immutable");
        }

        @Override
        protected final void removeDeepBinding(Name name, boolean pruneEmptyContexts) throws NamingException {
            throw new OperationNotSupportedException("Context is immutable");
        }

        @Override
        protected final boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
            throw new OperationNotSupportedException("Context is immutable");
        }

        @Override
        public boolean isNestedSubcontext(Object value) {
            if (value instanceof NestedImmutableContext) {
                NestedImmutableContext context = (NestedImmutableContext)value;
                return this.getImmutableContext() == context.getImmutableContext();
            }
            return false;
        }

        @Override
        public Context createNestedSubcontext(String path, Map<String, Object> bindings) {
            return new NestedImmutableContext(path, bindings);
        }

        protected ImmutableContext getImmutableContext() {
            return ImmutableContext.this;
        }
    }
}

