/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.valueextraction.ValueExtractor;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.openejb.assembler.classic.ValidationInfo;
import org.apache.openejb.bval.ValidatorUtil;
import org.apache.openejb.jee.bval.DefaultValidatedExecutableTypesType;
import org.apache.openejb.jee.bval.ExecutableValidationType;
import org.apache.openejb.jee.bval.PropertyType;
import org.apache.openejb.jee.bval.ValidationConfigType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;

public final class ValidatorBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, ValidatorBuilder.class);
    public static final String VALIDATION_PROVIDER_KEY = "openejb.bean-validation.provider";

    private ValidatorBuilder() {
    }

    public static ValidatorFactory buildFactory(ClassLoader classLoader, ValidationInfo info) {
        return ValidatorBuilder.buildFactory(info, classLoader);
    }

    public static ValidationInfo getInfo(ValidationConfigType config) {
        ValidationInfo info = new ValidationInfo();
        if (config != null) {
            info.version = config.getVersion();
            info.providerClassName = config.getDefaultProvider();
            info.constraintFactoryClass = config.getConstraintValidatorFactory();
            info.traversableResolverClass = config.getTraversableResolver();
            info.messageInterpolatorClass = config.getMessageInterpolator();
            info.parameterNameProviderClass = config.getParameterNameProvider();
            info.valueExtractorClassNames = config.getValueExtractor();
            info.clockProviderClassName = config.getClockProvider();
            ExecutableValidationType executableValidation = config.getExecutableValidation();
            if (executableValidation != null) {
                info.executableValidationEnabled = executableValidation.getEnabled();
                DefaultValidatedExecutableTypesType executableTypes = executableValidation.getDefaultValidatedExecutableTypes();
                if (executableTypes != null) {
                    for (ExecutableType type : executableTypes.getExecutableType()) {
                        info.validatedTypes.add(type.name());
                    }
                }
            }
            for (PropertyType p : config.getProperty()) {
                info.propertyTypes.put(p.getName(), p.getValue());
            }
            info.constraintMappings.addAll(config.getConstraintMapping());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidatorFactory buildFactory(ValidationInfo config, ClassLoader classLoader) {
        ValidatorFactory factory = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldContextLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            if (config == null) {
                factory = Validation.buildDefaultValidatorFactory();
            } else {
                Configuration<?> configuration = ValidatorBuilder.getConfig(config);
                try {
                    factory = configuration.buildValidatorFactory();
                }
                catch (ValidationException ve) {
                    thread.setContextClassLoader(ValidatorBuilder.class.getClassLoader());
                    factory = Validation.buildDefaultValidatorFactory();
                    thread.setContextClassLoader(classLoader);
                    logger.warning("Unable create validator factory with config " + config + " (" + ve.getMessage() + "). Default factory will be used.");
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldContextLoader);
        }
        return factory;
    }

    private static Configuration<?> getConfig(ValidationInfo info) {
        Class<?> clazz;
        String constraintFactoryClass;
        String traversableResolverClass;
        Configuration target = null;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        String providerClassName = info.providerClassName;
        if (providerClassName == null) {
            providerClassName = SystemInstance.get().getOptions().get(VALIDATION_PROVIDER_KEY, (String)null);
        }
        if (providerClassName != null) {
            try {
                Class<?> clazz2 = classLoader.loadClass(providerClassName);
                target = Validation.byProvider(clazz2).configure();
                logger.info("Using " + providerClassName + " as validation provider.");
            }
            catch (ClassNotFoundException e) {
                logger.warning("Unable to load provider class " + providerClassName, e);
            }
            catch (ValidationException ve) {
                logger.warning("Unable create validator factory with provider " + providerClassName + " (" + ve.getMessage() + "). Default one will be used.");
            }
        }
        if (target == null) {
            thread.setContextClassLoader(ValidatorBuilder.class.getClassLoader());
            target = Validation.byDefaultProvider().configure();
            thread.setContextClassLoader(classLoader);
        }
        EnumSet<ExecutableType> types = EnumSet.noneOf(ExecutableType.class);
        for (String string : info.validatedTypes) {
            types.add(ExecutableType.valueOf((String)string));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : info.propertyTypes.entrySet()) {
            PropertyType property = new PropertyType();
            property.setName((String)entry.getKey());
            property.setValue((String)entry.getValue());
            props.put(property.getName(), property.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug("Found property '" + property.getName() + "' with value '" + property.getValue());
            }
            target.addProperty(property.getName(), property.getValue());
        }
        OpenEjbBootstrapConfig openEjbBootstrapConfig = new OpenEjbBootstrapConfig(providerClassName, info.constraintFactoryClass, info.messageInterpolatorClass, info.traversableResolverClass, info.parameterNameProviderClass, new LinkedHashSet<String>(info.constraintMappings), info.executableValidationEnabled, types, props, info.clockProviderClassName, (Set<String>)(info.valueExtractorClassNames == null ? null : new LinkedHashSet<String>(info.valueExtractorClassNames)));
        OpenEjbConfig openEjbConfig = new OpenEjbConfig(openEjbBootstrapConfig, target);
        try {
            target.ignoreXmlConfiguration();
            logger.info("Ignoring XML Configuration for validator " + target.getClass().getName());
        }
        catch (Exception e) {
            logger.warning("Unable to ignore XML Configuration for validator " + target.getClass().getName(), e);
        }
        String messageInterpolatorClass = info.messageInterpolatorClass;
        if (messageInterpolatorClass != null) {
            try {
                Class<?> clazz3 = classLoader.loadClass(messageInterpolatorClass);
                target.messageInterpolator((MessageInterpolator)ValidatorBuilder.newInstance(openEjbConfig, clazz3));
                logger.info("Using " + messageInterpolatorClass + " as message interpolator.");
            }
            catch (Exception e) {
                logger.warning("Unable to set " + messageInterpolatorClass + " as message interpolator.", e);
            }
        }
        if ((traversableResolverClass = info.traversableResolverClass) != null) {
            try {
                Class<?> clazz4 = classLoader.loadClass(traversableResolverClass);
                target.traversableResolver((TraversableResolver)ValidatorBuilder.newInstance(openEjbConfig, clazz4));
                logger.info("Using " + traversableResolverClass + " as traversable resolver.");
            }
            catch (Exception e) {
                logger.warning("Unable to set " + traversableResolverClass + " as traversable resolver.", e);
            }
        }
        if ((constraintFactoryClass = info.constraintFactoryClass) != null) {
            try {
                clazz = classLoader.loadClass(constraintFactoryClass);
                target.constraintValidatorFactory((ConstraintValidatorFactory)ValidatorBuilder.newInstance(openEjbConfig, clazz));
            }
            catch (Exception e) {
                logger.warning("Unable to set " + constraintFactoryClass + " as constraint factory.", e);
            }
            logger.info("Using " + constraintFactoryClass + " as constraint factory.");
        }
        for (String mappingFileName : info.constraintMappings) {
            InputStream in;
            if (logger.isDebugEnabled()) {
                logger.debug("Opening input stream for " + mappingFileName);
            }
            if ((in = classLoader.getResourceAsStream(mappingFileName)) == null) {
                logger.warning("Unable to open input stream for mapping file " + mappingFileName + ". It will be ignored");
                continue;
            }
            target.addMapping(in);
        }
        if (info.parameterNameProviderClass != null) {
            try {
                clazz = classLoader.loadClass(info.parameterNameProviderClass);
                target.parameterNameProvider((ParameterNameProvider)ValidatorBuilder.newInstance(openEjbConfig, clazz));
                logger.info("Using " + info.parameterNameProviderClass + " as parameter name provider.");
            }
            catch (Exception e) {
                logger.warning("Unable to set " + info.parameterNameProviderClass + " as parameter name provider.", e);
            }
        }
        if (info.valueExtractorClassNames != null) {
            try {
                info.valueExtractorClassNames.stream().map(it -> {
                    try {
                        return (ValueExtractor)ValidatorBuilder.newInstance(config, classLoader.loadClass((String)it));
                    }
                    catch (Exception e) {
                        logger.warning("Unable to load " + it, e);
                        return null;
                    }
                }).filter(Objects::nonNull).forEach(arg_0 -> ((Configuration)target).addValueExtractor(arg_0));
                logger.info("Using " + info.valueExtractorClassNames + " value extractors.");
            }
            catch (Exception e) {
                logger.warning("Unable to set " + info.valueExtractorClassNames + " as parameter name provider.", e);
            }
        }
        if (info.clockProviderClassName != null) {
            try {
                clazz = classLoader.loadClass(info.clockProviderClassName);
                target.clockProvider((ClockProvider)ValidatorBuilder.newInstance(openEjbConfig, clazz));
                logger.info("Using " + info.clockProviderClassName + " as clock provider.");
            }
            catch (Exception e) {
                logger.warning("Unable to set " + info.clockProviderClassName + " as clock provider.", e);
            }
        }
        return openEjbConfig;
    }

    private static <T> T newInstance(OpenEjbConfig config, Class<T> clazz) throws Exception {
        WebBeansContext webBeansContext = AppFinder.findAppContextOrWeb(Thread.currentThread().getContextClassLoader(), AppFinder.WebBeansContextTransformer.INSTANCE);
        if (webBeansContext == null) {
            return clazz.newInstance();
        }
        BeanManagerImpl beanManager = webBeansContext.getBeanManagerImpl();
        if (!beanManager.isInUse()) {
            return clazz.newInstance();
        }
        AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
        InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
        CreationalContextImpl context = beanManager.createCreationalContext(null);
        Object instance = it.produce((CreationalContext)context);
        it.inject(instance, (CreationalContext)context);
        it.postConstruct(instance);
        config.releasables.add(new Releasable<Object>((CreationalContext<Object>)context, (InjectionTarget<Object>)it, instance));
        return (T)instance;
    }

    private static final class OpenEjbBootstrapConfig
    implements BootstrapConfiguration,
    Serializable {
        private final String providerClassName;
        private final String constraintFactoryClass;
        private final String messageInterpolatorClass;
        private final String traversableResolverClass;
        private final String parameterNameProviderClass;
        private final Set<String> constraintMappings;
        private final boolean executableValidationEnabled;
        private final Set<ExecutableType> validatedTypes;
        private final Map<String, String> props;
        private final String clockProviderClassName;
        private final Set<String> valueExtractorClassNames;

        public OpenEjbBootstrapConfig(String providerClassName, String constraintFactoryClass, String messageInterpolatorClass, String traversableResolverClass, String parameterNameProviderClass, Set<String> constraintMappings, boolean executableValidationEnabled, Set<ExecutableType> validatedTypes, Map<String, String> props, String clockProviderClassName, Set<String> valueExtractorClassNames) {
            this.providerClassName = providerClassName;
            this.constraintFactoryClass = constraintFactoryClass;
            this.messageInterpolatorClass = messageInterpolatorClass;
            this.traversableResolverClass = traversableResolverClass;
            this.parameterNameProviderClass = parameterNameProviderClass;
            this.constraintMappings = constraintMappings;
            this.executableValidationEnabled = executableValidationEnabled;
            this.validatedTypes = validatedTypes;
            this.props = props;
            this.clockProviderClassName = clockProviderClassName;
            this.valueExtractorClassNames = valueExtractorClassNames;
        }

        public String getDefaultProviderClassName() {
            return this.providerClassName;
        }

        public String getConstraintValidatorFactoryClassName() {
            return this.constraintFactoryClass;
        }

        public String getMessageInterpolatorClassName() {
            return this.messageInterpolatorClass;
        }

        public String getTraversableResolverClassName() {
            return this.traversableResolverClass;
        }

        public String getParameterNameProviderClassName() {
            return this.parameterNameProviderClass;
        }

        public Set<String> getConstraintMappingResourcePaths() {
            return this.constraintMappings;
        }

        public boolean isExecutableValidationEnabled() {
            return this.executableValidationEnabled;
        }

        public Set<ExecutableType> getDefaultValidatedExecutableTypes() {
            return this.validatedTypes;
        }

        public Map<String, String> getProperties() {
            return this.props;
        }

        public String getClockProviderClassName() {
            return this.clockProviderClassName;
        }

        public Set<String> getValueExtractorClassNames() {
            return this.valueExtractorClassNames;
        }
    }

    private static final class OpenEjbConfig<T extends Configuration<T>>
    implements Configuration<T> {
        private final Collection<Releasable<?>> releasables = new LinkedList();
        private final Configuration<T> delegate;
        private final BootstrapConfiguration bootstrap;

        public OpenEjbConfig(BootstrapConfiguration bootstrapConfig, Configuration<T> target) {
            this.bootstrap = bootstrapConfig;
            this.delegate = target;
        }

        public T ignoreXmlConfiguration() {
            return (T)this.delegate.ignoreXmlConfiguration();
        }

        public T messageInterpolator(MessageInterpolator interpolator) {
            return (T)this.delegate.messageInterpolator(interpolator);
        }

        public T traversableResolver(TraversableResolver resolver) {
            return (T)this.delegate.traversableResolver(resolver);
        }

        public T constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
            return (T)this.delegate.constraintValidatorFactory(constraintValidatorFactory);
        }

        public T addMapping(InputStream stream) {
            return (T)this.delegate.addMapping(stream);
        }

        public T addProperty(String name, String value) {
            return (T)this.delegate.addProperty(name, value);
        }

        public MessageInterpolator getDefaultMessageInterpolator() {
            return this.delegate.getDefaultMessageInterpolator();
        }

        public TraversableResolver getDefaultTraversableResolver() {
            return this.delegate.getDefaultTraversableResolver();
        }

        public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
            return this.delegate.getDefaultConstraintValidatorFactory();
        }

        public ValidatorFactory buildValidatorFactory() {
            return new OpenEJBValidatorFactory(this.delegate.buildValidatorFactory(), this.releasables);
        }

        public T parameterNameProvider(ParameterNameProvider parameterNameProvider) {
            return (T)this.delegate.parameterNameProvider(parameterNameProvider);
        }

        public ParameterNameProvider getDefaultParameterNameProvider() {
            return this.delegate.getDefaultParameterNameProvider();
        }

        public BootstrapConfiguration getBootstrapConfiguration() {
            return this.bootstrap;
        }

        public T clockProvider(ClockProvider clockProvider) {
            return (T)this.delegate.clockProvider(clockProvider);
        }

        public T addValueExtractor(ValueExtractor<?> valueExtractor) {
            return (T)this.delegate.addValueExtractor(valueExtractor);
        }

        public ClockProvider getDefaultClockProvider() {
            return this.delegate.getDefaultClockProvider();
        }
    }

    private static final class Releasable<T> {
        private final CreationalContext<T> context;
        private final InjectionTarget<T> injectionTarget;
        private final T instance;

        private Releasable(CreationalContext<T> context, InjectionTarget<T> injectionTarget, T instance) {
            this.context = context;
            this.injectionTarget = injectionTarget;
            this.instance = instance;
        }

        private void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
                this.injectionTarget.dispose(this.instance);
                this.context.release();
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
    }

    private static final class OpenEJBValidatorFactory
    implements ValidatorFactory,
    Serializable {
        private transient ValidatorFactory delegate;
        private transient Collection<Releasable<?>> toRelease;

        public OpenEJBValidatorFactory(ValidatorFactory validatorFactory, Collection<Releasable<?>> releasables) {
            this.delegate = validatorFactory;
            this.toRelease = releasables;
        }

        private ValidatorFactory delegate() {
            if (this.delegate != null) {
                return this.delegate;
            }
            try {
                return ValidatorUtil.lookupFactory();
            }
            catch (NamingException e) {
                return Validation.buildDefaultValidatorFactory();
            }
        }

        public Validator getValidator() {
            return this.delegate().getValidator();
        }

        public ValidatorContext usingContext() {
            return this.delegate().usingContext();
        }

        public MessageInterpolator getMessageInterpolator() {
            return this.delegate().getMessageInterpolator();
        }

        public TraversableResolver getTraversableResolver() {
            return this.delegate().getTraversableResolver();
        }

        public ConstraintValidatorFactory getConstraintValidatorFactory() {
            return this.delegate().getConstraintValidatorFactory();
        }

        public <T> T unwrap(Class<T> type) {
            return (T)this.delegate().unwrap(type);
        }

        public ParameterNameProvider getParameterNameProvider() {
            return this.delegate().getParameterNameProvider();
        }

        public ClockProvider getClockProvider() {
            return this.delegate().getClockProvider();
        }

        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
            if (this.toRelease != null) {
                for (Releasable<?> r : this.toRelease) {
                    r.release();
                }
            }
        }
    }
}

