/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.authorizer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ReqContext;

public class SimpleWhitelistAuthorizer
implements IAuthorizer {
    public static final String WHITELIST_USERS_CONF = "storm.auth.simple-white-list.users";
    protected Set<String> users;

    @Override
    public void prepare(Map<String, Object> conf) {
        this.users = new HashSet<String>();
        if (conf.containsKey(WHITELIST_USERS_CONF)) {
            this.users.addAll((Collection)conf.get(WHITELIST_USERS_CONF));
        }
    }

    @Override
    public boolean permit(ReqContext context, String operation, Map<String, Object> topoConf) {
        return context.principal() != null ? this.users.contains(context.principal().getName()) : false;
    }
}

