/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.cgroup;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.util.Map;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.MemoryCore;
import org.apache.storm.metrics2.WorkerMetricRegistrant;
import org.apache.storm.metrics2.cgroup.CGroupMetricsBase;
import org.apache.storm.task.TopologyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupMemoryLimit
extends CGroupMetricsBase
implements WorkerMetricRegistrant {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupMemoryLimit.class);
    private static final long BYTES_PER_MB = 0x100000L;
    private final long workerLimitBytes;

    public CGroupMemoryLimit(Map<String, Object> conf) {
        super(conf, SubSystemType.memory);
        long limit = -1L;
        try {
            limit = Long.valueOf(System.getProperty("worker.memory_limit_mb", "-1"));
        }
        catch (NumberFormatException e) {
            LOG.warn("Error Parsing worker.memory_limit_mb {}", (Throwable)e);
        }
        this.workerLimitBytes = 0x100000L * limit;
    }

    @Override
    public void registerMetrics(TopologyContext topologyContext) {
        if (this.enabled) {
            topologyContext.registerGauge("CGroupMemoryLimit", new Gauge<Long>(){

                public Long getValue() {
                    if (CGroupMemoryLimit.this.workerLimitBytes > 0L) {
                        return CGroupMemoryLimit.this.workerLimitBytes;
                    }
                    try {
                        return ((MemoryCore)CGroupMemoryLimit.this.core).getPhysicalUsageLimit();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

