/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.scheduler.utils.IConfigLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoaderFactoryService {
    private static Logger LOG = LoggerFactory.getLogger(IConfigLoaderFactory.class);
    private static ServiceLoader<IConfigLoaderFactory> serviceLoader = ServiceLoader.load(IConfigLoaderFactory.class);

    public static IConfigLoader createConfigLoader(Map<String, Object> conf) {
        String uriString = (String)conf.get("scheduler.config.loader.uri");
        if (null != uriString) {
            try {
                URI uri = new URI(uriString);
                for (IConfigLoaderFactory factory : serviceLoader) {
                    IConfigLoader ret = factory.createIfSupported(uri, conf);
                    if (ret == null) continue;
                    return ret;
                }
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to parse uri={}", (Object)uriString);
            }
        } else {
            LOG.debug("Config {} is not set.", (Object)"scheduler.config.loader.uri");
        }
        return null;
    }
}

