/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;

public class MockLeaderElector
implements ILeaderElector {
    private final boolean isLeader;
    private final NimbusInfo leaderAddress;

    public MockLeaderElector() {
        this(true, "test-host", 9999);
    }

    public MockLeaderElector(boolean isLeader) {
        this(isLeader, "test-host", 9999);
    }

    public MockLeaderElector(boolean isLeader, String host, int port) {
        this.isLeader = isLeader;
        this.leaderAddress = new NimbusInfo(host, port, true);
    }

    public void prepare(Map<String, Object> conf) {
    }

    public void addToLeaderLockQueue() throws Exception {
    }

    public void quitElectionFor(int delayMs) throws Exception {
    }

    public boolean isLeader() throws Exception {
        return this.isLeader;
    }

    public boolean awaitLeadership(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.isLeader;
    }

    public NimbusInfo getLeader() {
        return this.leaderAddress;
    }

    public List<NimbusInfo> getAllNimbuses() throws Exception {
        return Arrays.asList(this.leaderAddress);
    }

    public void close() {
    }
}

