/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import org.apache.storm.streams.operations.Reducer;
import org.apache.storm.streams.processors.BaseProcessor;
import org.apache.storm.streams.processors.BatchProcessor;

public class ReduceProcessor<T>
extends BaseProcessor<T>
implements BatchProcessor {
    private final Reducer<T> reducer;
    private T agg;

    public ReduceProcessor(Reducer<T> reducer) {
        this.reducer = reducer;
    }

    @Override
    public void execute(T input) {
        this.agg = this.agg == null ? input : this.reducer.apply(this.agg, input);
        this.mayBeForwardAggUpdate(() -> this.agg);
    }

    @Override
    public void finish() {
        if (this.agg != null) {
            this.context.forward(this.agg);
            this.agg = null;
        }
    }
}

