/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.nio.file.Path;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.sis.io.stream.InternalOptionKey;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStoreProvider;
import org.apache.sis.storage.gdal.Driver;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.Opener;
import org.apache.sis.storage.panama.LibraryStatus;
import org.apache.sis.storage.panama.Resources;
import org.apache.sis.system.Cleaners;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@StoreMetadata(formatName="GDAL", capabilities={Capability.READ}, resourceTypes={Aggregate.class, GridCoverageResource.class}, yieldPriority=true)
public class GDALStoreProvider
extends DataStoreProvider {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.gdal");
    public static final OptionKey<String[]> DRIVERS_OPTION_KEY = new InternalOptionKey("DRIVERS", String[].class);
    static final ParameterDescriptor<String[]> DRIVERS_PARAM;
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR;
    private GDAL nativeFunctions;
    private LibraryStatus status;

    public GDALStoreProvider() {
    }

    public GDALStoreProvider(Path library) {
        this.nativeFunctions = GDAL.load(library);
        Cleaners.SHARED.register((Object)this, this.nativeFunctions);
        this.status = LibraryStatus.LOADED;
    }

    final synchronized GDAL GDAL() throws DataStoreException {
        if (this.status == null) {
            return GDAL.global();
        }
        this.status.report("GDAL", null);
        return this.nativeFunctions;
    }

    final synchronized Optional<GDAL> tryGDAL(Class<?> classe, String method) {
        if (this.status == null) {
            return GDAL.tryGlobal(classe, method);
        }
        return Optional.ofNullable(this.nativeFunctions);
    }

    final synchronized void fatalError() {
        this.nativeFunctions = null;
        this.status = LibraryStatus.FATAL_ERROR;
    }

    public String getShortName() {
        return "GDAL";
    }

    private <V> Optional<V> version(String caller, String request, Function<String, V> mapper) {
        return this.tryGDAL(GDALStoreProvider.class, caller).flatMap(gdal -> gdal.version(request)).map(mapper);
    }

    public Optional<Version> getVersion() {
        return this.version("getVersion", "VERSION_NUM", version -> {
            int n = Integer.parseInt(version);
            int[] components = new int[4];
            int i = components.length;
            while (--i >= 0) {
                components[i] = n % 100;
                n /= 100;
            }
            return Version.valueOf((int[])components);
        });
    }

    public Optional<LocalDate> getReleaseDate() {
        return this.version("getReleaseDate", "RELEASE_DATE", version -> {
            int year = Integer.parseInt(version);
            int day = year % 100;
            int month = (year /= 100) % 100;
            return LocalDate.of(year /= 100, month, day);
        });
    }

    public List<Driver> getDrivers() {
        return Driver.list(this, this.tryGDAL(GDALStoreProvider.class, "getDrivers").orElse(null));
    }

    public TreeTable configuration() throws DataStoreException {
        return Driver.configuration(this, this.tryGDAL(GDALStoreProvider.class, "configuration").orElse(null));
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return Opener.probeContent(this, connector);
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new GDALStore(this, connector);
    }

    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        Parameters p = Parameters.castOrWrap((ParameterValueGroup)parameters);
        StorageConnector connector = new StorageConnector(p.getValue(URIDataStoreProvider.LOCATION_PARAM));
        String[] drivers = (String[])p.getValue(DRIVERS_PARAM);
        if (drivers != null) {
            connector.setOption(DRIVERS_OPTION_KEY, (Object)drivers);
        }
        return this.open(connector);
    }

    public Logger getLogger() {
        return LOGGER;
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        DRIVERS_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"drivers")).setDescription((CharSequence)Resources.formatInternational((short)1, "GDAL"))).create(String[].class, null);
        OPEN_DESCRIPTOR = ((ParameterBuilder)builder.addName((CharSequence)"GDAL")).createGroup(new GeneralParameterDescriptor[]{URIDataStoreProvider.LOCATION_PARAM, DRIVERS_PARAM});
    }
}

