/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.sis.coordinate.AbstractCoordinateSet;
import org.apache.sis.coordinate.DefaultCoordinateMetadata;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class TransformedCoordinateSet
extends AbstractCoordinateSet
implements UnaryOperator<DirectPosition> {
    private static final long serialVersionUID = -6533100977777070894L;
    private final AbstractCoordinateSet data;
    private final MathTransform transform;

    TransformedCoordinateSet(AbstractCoordinateOperation op, AbstractCoordinateSet data) throws TransformException {
        super(new DefaultCoordinateMetadata(op.getTargetCRS(), op.getTargetEpoch().orElse(null)));
        MathTransform transform = op.getMathTransform();
        if (transform == null) {
            throw new TransformException(Resources.format((short)43, op.getClass(), op.getName()));
        }
        DefaultCoordinateMetadata metadata = data.getCoordinateMetadata();
        if (metadata != null) {
            try {
                CoordinateOperationContext context = CoordinateOperationContext.fromBoundingBox(CRS.getGeographicBoundingBox(op));
                DefaultCoordinateMetadata step = new DefaultCoordinateMetadata(op.getSourceCRS(), op.getSourceEpoch().orElse(null));
                transform = MathTransforms.concatenate(CRS.findOperation(metadata, step, context).getMathTransform(), transform);
            }
            catch (MismatchedDimensionException | FactoryException e) {
                throw new TransformException(e.getMessage(), e);
            }
        }
        this.transform = transform;
        this.data = data;
    }

    @Override
    public int getDimension() {
        return this.transform.getTargetDimensions();
    }

    @Override
    public Iterator<DirectPosition> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Spliterator<DirectPosition> spliterator() {
        return this.stream().spliterator();
    }

    @Override
    public Stream<DirectPosition> stream() {
        return this.data.stream().map(this);
    }

    @Override
    public void forEach(Consumer<? super DirectPosition> action) {
        this.stream().forEach(action);
    }

    @Override
    public DirectPosition apply(DirectPosition source) {
        try {
            return this.transform.transform(source, null);
        }
        catch (TransformException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }
}

