/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.HyperRectangleWriter;
import org.apache.sis.io.stream.Region;

final class SubsampledRectangleWriter
extends HyperRectangleWriter {
    private final int[] bandOffsets;
    private final int pixelStride;

    SubsampledRectangleWriter(Region region, int[] bandOffsets, int pixelStride) {
        super(region);
        this.bandOffsets = bandOffsets;
        this.pixelStride = pixelStride;
    }

    @Override
    public boolean suggestDirect(ChannelDataOutput output) {
        return false;
    }

    private void write(ChannelDataOutput output, int offset, int sampleSize, Data data) throws IOException {
        ByteBuffer target = output.buffer;
        int numBands = this.bandOffsets.length;
        int pixelSize = numBands * sampleSize;
        int[] count = this.count();
        offset = this.startAt(offset);
        do {
            int index = offset;
            int end = index + this.contiguousDataLength;
            do {
                output.ensureBufferAccepts(pixelSize);
                int numPixels = Math.min((end - index) / this.pixelStride, (target.capacity() - target.position()) / pixelSize);
                target.limit(target.position() + numPixels * pixelSize);
            } while ((index = numBands == 1 ? data.fill(target, index + this.bandOffsets[0], this.pixelStride) : data.fill(target, index, this.bandOffsets, this.pixelStride)) < end);
        } while ((offset = this.next(offset, count)) >= 0);
    }

    @Override
    public void write(ChannelDataOutput output, final byte[] data, int offset, boolean direct) throws IOException {
        if (direct) {
            throw new UnsupportedOperationException();
        }
        this.write(output, offset, 1, new Data(this){
            final /* synthetic */ SubsampledRectangleWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            int fill(ByteBuffer target, int index, int stride) {
                while (target.hasRemaining()) {
                    target.put(data[index]);
                    index += stride;
                }
                return index;
            }

            @Override
            int fill(ByteBuffer target, int index, int[] bands, int stride) {
                while (target.hasRemaining()) {
                    for (int b : bands) {
                        target.put(data[index + b]);
                    }
                    index += stride;
                }
                return index;
            }
        });
    }

    @Override
    public void write(ChannelDataOutput output, final short[] data, int offset) throws IOException {
        this.write(output, offset, 2, new Data(this){
            final /* synthetic */ SubsampledRectangleWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            int fill(ByteBuffer target, int index, int stride) {
                while (target.hasRemaining()) {
                    target.putShort(data[index]);
                    index += stride;
                }
                return index;
            }

            @Override
            int fill(ByteBuffer target, int index, int[] bands, int stride) {
                while (target.hasRemaining()) {
                    for (int b : bands) {
                        target.putShort(data[index + b]);
                    }
                    index += stride;
                }
                return index;
            }
        });
    }

    @Override
    public void write(ChannelDataOutput output, final int[] data, int offset) throws IOException {
        this.write(output, offset, 4, new Data(this){
            final /* synthetic */ SubsampledRectangleWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            int fill(ByteBuffer target, int index, int stride) {
                while (target.hasRemaining()) {
                    target.putInt(data[index]);
                    index += stride;
                }
                return index;
            }

            @Override
            int fill(ByteBuffer target, int index, int[] bands, int stride) {
                while (target.hasRemaining()) {
                    for (int b : bands) {
                        target.putInt(data[index + b]);
                    }
                    index += stride;
                }
                return index;
            }
        });
    }

    @Override
    public void write(ChannelDataOutput output, final long[] data, int offset) throws IOException {
        this.write(output, offset, 8, new Data(this){
            final /* synthetic */ SubsampledRectangleWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            int fill(ByteBuffer target, int index, int stride) {
                while (target.hasRemaining()) {
                    target.putLong(data[index]);
                    index += stride;
                }
                return index;
            }

            @Override
            int fill(ByteBuffer target, int index, int[] bands, int stride) {
                while (target.hasRemaining()) {
                    for (int b : bands) {
                        target.putLong(data[index + b]);
                    }
                    index += stride;
                }
                return index;
            }
        });
    }

    @Override
    public void write(ChannelDataOutput output, final float[] data, int offset) throws IOException {
        this.write(output, offset, 4, new Data(this){
            final /* synthetic */ SubsampledRectangleWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            int fill(ByteBuffer target, int index, int stride) {
                while (target.hasRemaining()) {
                    target.putFloat(data[index]);
                    index += stride;
                }
                return index;
            }

            @Override
            int fill(ByteBuffer target, int index, int[] bands, int stride) {
                while (target.hasRemaining()) {
                    for (int b : bands) {
                        target.putFloat(data[index + b]);
                    }
                    index += stride;
                }
                return index;
            }
        });
    }

    @Override
    public void write(ChannelDataOutput output, final double[] data, int offset) throws IOException {
        this.write(output, offset, 8, new Data(this){
            final /* synthetic */ SubsampledRectangleWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            int fill(ByteBuffer target, int index, int stride) {
                while (target.hasRemaining()) {
                    target.putDouble(data[index]);
                    index += stride;
                }
                return index;
            }

            @Override
            int fill(ByteBuffer target, int index, int[] bands, int stride) {
                while (target.hasRemaining()) {
                    for (int b : bands) {
                        target.putDouble(data[index + b]);
                    }
                    index += stride;
                }
                return index;
            }
        });
    }

    private static abstract class Data {
        Data() {
        }

        abstract int fill(ByteBuffer var1, int var2, int var3);

        abstract int fill(ByteBuffer var1, int var2, int[] var3, int var4);
    }
}

