/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.provider.PolarStereographicA;
import org.apache.sis.referencing.operation.provider.PolarStereographicB;
import org.apache.sis.referencing.operation.provider.PolarStereographicC;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class PolarStereographic
extends ConformalProjection {
    private static final long serialVersionUID = -6635298308431138524L;

    public PolarStereographic(OperationMethod method, Parameters parameters) {
        this(PolarStereographic.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)PolarStereographic.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.B);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        ParameterDescriptor<Double> falseEasting = PolarStereographicA.FALSE_EASTING;
        ParameterDescriptor<Double> falseNorthing = PolarStereographicA.FALSE_NORTHING;
        if (variant == Variant.C) {
            falseEasting = PolarStereographicC.EASTING_AT_FALSE_ORIGIN;
            falseNorthing = PolarStereographicC.NORTHING_AT_FALSE_ORIGIN;
        }
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, falseEasting);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, falseNorthing);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, PolarStereographicA.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, variant == Variant.A ? PolarStereographicA.LONGITUDE_OF_ORIGIN : PolarStereographicB.LONGITUDE_OF_ORIGIN);
        return new Initializer(method, parameters, roles, variant);
    }

    private PolarStereographic(Initializer initializer) {
        super(initializer);
        Double \u03c1F;
        Double \u03c1;
        Variant variant = (Variant)initializer.variant;
        double \u03c60 = variant == Variant.A ? initializer.getAndStore(PolarStereographicA.LATITUDE_OF_ORIGIN) : initializer.getAndStore(PolarStereographicA.LATITUDE_OF_ORIGIN, variant == Variant.NORTH ? 90.0 : (variant == Variant.SOUTH ? -90.0 : Double.NaN));
        if (Math.abs(Math.abs(\u03c60) - 90.0) > 8.999280057595393E-8) {
            throw new IllegalArgumentException(Resources.format((short)25, PolarStereographicA.LATITUDE_OF_ORIGIN.getName(), \u03c60));
        }
        double \u03c61 = variant == Variant.B || variant == Variant.C || Double.isNaN(\u03c60) ? initializer.getAndStore(PolarStereographicB.STANDARD_PARALLEL) : initializer.getAndStore(PolarStereographicB.STANDARD_PARALLEL, \u03c60);
        boolean isNorth = MathFunctions.isPositive((double)\u03c61);
        if (isNorth) {
            \u03c61 = -\u03c61;
        }
        if (Math.abs((\u03c61 = Math.toRadians(\u03c61)) + 1.5707963267948966) < 1.5706706731410455E-9) {
            \u03c1 = 2.0 / Math.sqrt(Math.pow(1.0 + this.eccentricity, 1.0 + this.eccentricity) * Math.pow(1.0 - this.eccentricity, 1.0 - this.eccentricity));
            \u03c1F = null;
        } else {
            double sin\u03c61 = Math.sin(\u03c61);
            double mF = initializer.scaleAt\u03c6(sin\u03c61, Math.cos(\u03c61));
            \u03c1 = mF / this.exp\u03a8(\u03c61, this.eccentricity * sin\u03c61);
            \u03c1F = variant == Variant.C ? Double.valueOf(-mF) : null;
        }
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, \u03c1, null);
        denormalize.convertBefore(1, \u03c1, \u03c1F);
        if (isNorth) {
            MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            DoubleDouble reverseSign = DoubleDouble.of((int)-1);
            normalize.convertAfter(1, (Number)reverseSign, null);
            denormalize.convertBefore(1, (Number)reverseSign, null);
        }
    }

    PolarStereographic(PolarStereographic other) {
        super(other);
    }

    @Override
    public MathTransform createMapProjection(MathTransformProvider.Context parameters) throws FactoryException {
        PolarStereographic kernel = this;
        if (this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(parameters.getFactory(), kernel);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) {
        return Optional.of(new Envelope2D(null, -Math.PI, -1.5707963267948966, Math.PI * 2, 1.5707963267948966));
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03b8 = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03b8 = Math.sin(\u03b8);
        double cos\u03b8 = Math.cos(\u03b8);
        double sin\u03c6 = Math.sin(\u03c6);
        double t = this.exp\u03a8(\u03c6, this.eccentricity * sin\u03c6);
        double x = t * sin\u03b8;
        double y = t * cos\u03b8;
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        double dt = t * this.dy_d\u03c6(sin\u03c6, Math.cos(\u03c6));
        return new Matrix2(y, dt * sin\u03b8, -x, dt * cos\u03b8);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = Math.atan2(x, y);
        dstPts[dstOff + 1] = -this.\u03c6(Formulas.fastHypot(x, y));
    }

    private static enum Variant implements ProjectionVariant
    {
        A(".*\\bvariant\\s*A\\b.*", "9810"),
        B(".*\\bvariant\\s*B\\b.*", "9829"),
        C(".*\\bvariant\\s*C\\b.*", "9830"),
        NORTH(".*\\bNorth\\b.*", null),
        SOUTH(".*\\bSouth\\b.*", null);

        private final Pattern operationName;
        private final String identifier;

        private Variant(String operationName, String identifier) {
            this.operationName = Pattern.compile(operationName, 2);
            this.identifier = identifier;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends PolarStereographic {
        private static final long serialVersionUID = 1655096575897215547L;

        protected Spherical(PolarStereographic other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03b8 = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03b8 = Math.sin(\u03b8);
            double cos\u03b8 = Math.cos(\u03b8);
            double t = Math.tan(0.7853981633974483 + 0.5 * \u03c6);
            double x = t * sin\u03b8;
            double y = t * cos\u03b8;
            if (dstPts != null) {
                dstPts[dstOff] = x;
                dstPts[dstOff + 1] = y;
            }
            if (!derivate) {
                return null;
            }
            double dt = t / Math.cos(\u03c6);
            return new Matrix2(y, dt * sin\u03b8, -x, dt * cos\u03b8);
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double \u03c1 = Math.hypot(x, y);
            dstPts[dstOff] = Math.atan2(x, y);
            dstPts[dstOff + 1] = 2.0 * Math.atan(\u03c1) - 1.5707963267948966;
        }
    }
}

