/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui;

import java.awt.SplashScreen;
import java.awt.im.InputContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.sis.gui.AboutDialog;
import org.apache.sis.gui.RecentFiles;
import org.apache.sis.gui.SystemMonitor;
import org.apache.sis.gui.dataset.ResourceExplorer;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.internal.RecentChoices;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;

public class DataViewer
extends Application {
    private static volatile DataViewer running;
    private Stage window;
    private ResourceExplorer content;
    private FileChooser.ExtensionFilter[] openFilters;
    private FileChooser.ExtensionFilter[] saveFilters;
    private FileChooser.ExtensionFilter lastFilter;
    private Stage systemLogsWindow;

    public static void main(String[] args) {
        LogHandler.register(true);
        InputContext.getInstance();
        DataViewer.launch(DataViewer.class, (String[])args);
    }

    public void start(Stage window) {
        MenuItem close;
        MenuItem oUrl;
        MenuItem open;
        this.window = window;
        this.content = new ResourceExplorer();
        Resources localized = Resources.getInstance();
        Vocabulary vocabulary = Vocabulary.forLocale((Locale)localized.getLocale());
        MenuBar menus = new MenuBar();
        Menu file = new Menu(vocabulary.getString((short)82));
        Menu recentFiles = RecentFiles.create(this.content, localized);
        file.getItems().addAll((Object[])new MenuItem[]{open = localized.menu((short)28, (EventHandler<ActionEvent>)((EventHandler)e -> this.showOpenFileDialog())), oUrl = localized.menu((short)70, (EventHandler<ActionEvent>)((EventHandler)e -> this.showOpenURLDialog())), recentFiles, close = localized.menu((short)10, (EventHandler<ActionEvent>)((EventHandler)e -> this.closeSelectedFile())), new SeparatorMenuItem(), localized.menu((short)20, (EventHandler<ActionEvent>)((EventHandler)e -> Platform.exit()))});
        open.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+O"));
        oUrl.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+U"));
        close.setDisable(true);
        this.content.selectedResourceProperty().addListener((e, o, n) -> close.setDisable(!(n instanceof DataStore)));
        Menu windows = new Menu(localized.getString((short)21));
        ObservableList items = windows.getItems();
        MenuItem monitor = new MenuItem(localized.getString((short)64));
        monitor.setOnAction(e -> this.showSystemMonitorWindow());
        items.addAll((Object[])new MenuItem[]{monitor});
        Menu help = new Menu(localized.getString((short)47));
        help.getItems().addAll((Object[])new MenuItem[]{localized.menu((short)48, (EventHandler<ActionEvent>)((EventHandler)e -> this.getHostServices().showDocument("https://sis.apache.org/javafx.html"))), localized.menu((short)46, (EventHandler<ActionEvent>)((EventHandler)e -> AboutDialog.show()))});
        menus.getMenus().addAll((Object[])new Menu[]{file, windows, help});
        BorderPane pane = new BorderPane();
        pane.setTop((Node)menus);
        pane.setCenter((Node)this.content.getView());
        Scene scene = new Scene((Parent)pane);
        URL css = DataViewer.class.getResource("pseudo-classes.css");
        if (css != null) {
            scene.getStylesheets().add((Object)css.toExternalForm());
        }
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        window.setTitle("Apache Spatial Information System");
        window.getIcons().addAll((Object[])new Image[]{new Image(DataViewer.class.getResourceAsStream("SIS_64px.png")), new Image(DataViewer.class.getResourceAsStream("SIS_128px.png"))});
        window.setScene(scene);
        window.setWidth(0.75 * bounds.getWidth());
        window.setHeight(0.75 * bounds.getHeight());
        window.show();
        SplashScreen sp = SplashScreen.getSplashScreen();
        if (sp != null) {
            sp.close();
        }
        running = this;
    }

    private void createFileFilters() {
        Resources res = Resources.getInstance();
        LinkedHashSet<String> suffixes = new LinkedHashSet<String>();
        LinkedHashSet<String> allSuffixes = new LinkedHashSet<String>();
        ArrayList<FileChooser.ExtensionFilter> open = new ArrayList<FileChooser.ExtensionFilter>();
        ArrayList<FileChooser.ExtensionFilter> save = new ArrayList<FileChooser.ExtensionFilter>();
        open.add(new FileChooser.ExtensionFilter(res.getString((short)1), new String[]{"*.*"}));
        block10: for (DataStoreProvider provider : DataStores.providers()) {
            StoreMetadata md = provider.getClass().getAnnotation(StoreMetadata.class);
            if (md == null) continue;
            boolean read = true;
            boolean write = true;
            switch (md.formatName()) {
                case "WKT": {
                    continue block10;
                }
                case "XML": {
                    write = false;
                    break;
                }
                case "GPX": {
                    read = false;
                }
            }
            String label = null;
            for (String suffix : md.fileSuffixes()) {
                String fs = "*.".concat(suffix);
                suffixes.add(fs);
                suffixes.add(fs.toUpperCase());
                if (label != null) continue;
                label = fs;
            }
            if (label == null) continue;
            FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(md.formatName() + " (" + label + ")", (String[])suffixes.toArray(String[]::new));
            Object[] capabilities = md.capabilities();
            if (read && ArraysExt.contains((Object[])capabilities, (Object)Capability.READ)) {
                allSuffixes.addAll(suffixes);
                open.add(f);
            }
            if (write && ArraysExt.contains((Object[])capabilities, (Object)Capability.WRITE)) {
                save.add(f);
            }
            suffixes.clear();
        }
        open.add(1, new FileChooser.ExtensionFilter(res.getString((short)23), (String[])allSuffixes.toArray(String[]::new)));
        this.openFilters = (FileChooser.ExtensionFilter[])open.toArray(FileChooser.ExtensionFilter[]::new);
        this.saveFilters = (FileChooser.ExtensionFilter[])save.toArray(FileChooser.ExtensionFilter[]::new);
    }

    private void showOpenFileDialog() {
        if (this.openFilters == null) {
            this.createFileFilters();
            this.lastFilter = this.openFilters[1];
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle(Resources.format((short)29));
        chooser.getExtensionFilters().addAll((Object[])this.openFilters);
        chooser.setSelectedExtensionFilter(this.lastFilter);
        chooser.setInitialDirectory(RecentChoices.getOpenDirectory());
        List files = chooser.showOpenMultipleDialog((Window)this.window);
        if (files != null) {
            RecentChoices.setOpenDirectory(files);
            this.lastFilter = chooser.getSelectedExtensionFilter();
            this.content.loadResources(files);
        }
    }

    private void showOpenURLDialog() {
        TextInputDialog chooser = new TextInputDialog();
        ListView recents = new ListView();
        RecentChoices.getURLs((Collection<String>)recents.getItems());
        recents.setPrefWidth(500.0);
        recents.setPrefHeight(200.0);
        recents.getSelectionModel().selectedItemProperty().addListener((p, o, n) -> chooser.getEditor().setText(n));
        DialogPane pane = chooser.getDialogPane();
        pane.setHeaderText(Resources.format((short)71));
        pane.setExpandableContent((Node)recents);
        pane.setExpanded(true);
        chooser.setTitle(Resources.format((short)29));
        chooser.initOwner((Window)this.window);
        chooser.showAndWait().ifPresent(choice -> {
            try {
                URI url = new URI((String)choice);
                LinkedHashSet<String> save = new LinkedHashSet<String>(16);
                save.add(url.toString());
                for (String old : recents.getItems()) {
                    save.add(old);
                    if (save.size() < 10) continue;
                    break;
                }
                RecentChoices.setURLs(save);
                this.content.loadResources(Set.of(url));
            }
            catch (URISyntaxException e) {
                ExceptionReporter.canNotReadFile((Node)this.content.getView(), choice, (Throwable)e);
            }
        });
    }

    private void showSystemMonitorWindow() {
        if (this.systemLogsWindow == null) {
            this.systemLogsWindow = SystemMonitor.create(this.window, null);
        }
        this.systemLogsWindow.show();
        this.systemLogsWindow.toFront();
    }

    private void closeSelectedFile() {
        this.content.removeAndClose(this.content.getSelectedResource());
    }

    public void stop() throws Exception {
        running = null;
        LogHandler.register(false);
        BackgroundThreads.stop();
        RecentChoices.saveReferenceSystems();
        super.stop();
    }

    public static Stage getCurrentStage() {
        DataViewer r = running;
        return r != null ? r.window : null;
    }
}

