/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static final String STRATEGY_KEY = "servicecomb.flowcontrol.strategy";
    public static final String ANY_SERVICE = "ANY";
    public static final String CONSUMER_BUCKET_KEY_PREFIX = "servicecomb.flowcontrol.Consumer.qps.bucket.";
    public static final String PROVIDER_BUCKET_KEY_PREFIX = "servicecomb.flowcontrol.Provider.qps.bucket.";
    public static final String PROVIDER_BUCKET_KEY_GLOBAL = "servicecomb.flowcontrol.Provider.qps.global.bucket";
    public static final String CONSUMER_BUCKET_KEY_GLOBAL = "servicecomb.flowcontrol.Consumer.qps.global.bucket";
    public static final String CONSUMER_LIMIT_KEY_PREFIX = "servicecomb.flowcontrol.Consumer.qps.limit.";
    public static final String PROVIDER_LIMIT_KEY_PREFIX = "servicecomb.flowcontrol.Provider.qps.limit.";
    public static final String PROVIDER_LIMIT_KEY_GLOBAL = "servicecomb.flowcontrol.Provider.qps.global.limit";
    public static final String CONSUMER_LIMIT_KEY_GLOBAL = "servicecomb.flowcontrol.Consumer.qps.global.limit";
    public static final String CONSUMER_ENABLED = "servicecomb.flowcontrol.Consumer.qps.enabled";
    public static final String PROVIDER_ENABLED = "servicecomb.flowcontrol.Provider.qps.enabled";
    public static Config INSTANCE = new Config();
    private final DynamicBooleanProperty consumerEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.flowcontrol.Consumer.qps.enabled", true);
    private final DynamicBooleanProperty providerEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.flowcontrol.Provider.qps.enabled", true);

    public Config() {
        this.consumerEnabled.addCallback(() -> {
            boolean newValue = this.consumerEnabled.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{CONSUMER_ENABLED, this.consumerEnabled, newValue});
        });
        this.providerEnabled.addCallback(() -> {
            boolean newValue = this.providerEnabled.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{PROVIDER_ENABLED, this.providerEnabled, newValue});
        });
    }

    public boolean isConsumerEnabled() {
        return this.consumerEnabled.get();
    }

    public boolean isProviderEnabled() {
        return this.providerEnabled.get();
    }
}

