/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.http.client.event.OperationEvents;
import org.apache.servicecomb.registry.api.event.ServiceCenterEventBus;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.model.RbacTokenRequest;
import org.apache.servicecomb.service.center.client.model.RbacTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenCacheManager.class);
    public static final String INVALID_TOKEN = "";
    private static final TokenCacheManager INSTANCE = new TokenCacheManager();
    private Map<String, ServiceCenterClient> serviceCenterClients;
    private TokenCache tokenCache;

    public static TokenCacheManager getInstance() {
        return INSTANCE;
    }

    private TokenCacheManager() {
    }

    public void setServiceCenterClients(Map<String, ServiceCenterClient> serviceCenterClients) {
        this.serviceCenterClients = serviceCenterClients;
    }

    public void addTokenCache(String registryName, String accountName, String password, Cipher cipher) {
        this.tokenCache = new TokenCache(registryName, accountName, password, cipher);
    }

    public String getToken(String host) {
        if (this.tokenCache == null) {
            return null;
        }
        return this.tokenCache.getToken(host);
    }

    public class TokenCache {
        private static final long TOKEN_REFRESH_TIME_IN_SECONDS = 1200000L;
        private final String registryName;
        private final String accountName;
        private final String password;
        private ExecutorService executorService;
        private LoadingCache<String, String> cache;
        private final Cipher cipher;

        public TokenCache(String registryName, String accountName, String password, Cipher cipher) {
            this.registryName = registryName;
            this.accountName = accountName;
            this.password = password;
            this.cipher = cipher;
            if (this.enabled()) {
                this.executorService = Executors.newFixedThreadPool(1, t -> new Thread(t, "rbac-executor-" + this.registryName){

                    @Override
                    public void run() {
                        try {
                            super.run();
                        }
                        catch (Throwable e) {
                            LOGGER.error(TokenCacheManager.INVALID_TOKEN, e);
                        }
                    }
                });
                this.cache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(this.refreshTime(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, String>(){

                    public String load(String key) throws Exception {
                        return TokenCache.this.createHeaders(key);
                    }

                    public ListenableFuture<String> reload(String key, String oldValue) throws Exception {
                        return Futures.submit(() -> TokenCache.this.createHeaders(key), (Executor)TokenCache.this.executorService);
                    }
                });
                ServiceCenterEventBus.getEventBus().register((Object)this);
            }
        }

        @Subscribe
        public void onUnAuthorizedOperationEvent(OperationEvents.UnAuthorizedOperationEvent event) {
            LOGGER.warn("address {} unAuthorized, refresh cache token!", (Object)event.getAddress());
            this.cache.refresh((Object)this.getHostByAddress(event.getAddress()));
        }

        private String getHostByAddress(String address) {
            try {
                URI uri = URI.create(address);
                return uri.getHost();
            }
            catch (Exception e) {
                LOGGER.error("get host by address [{}] error!", (Object)address, (Object)e);
                return this.registryName;
            }
        }

        private String createHeaders(String host) {
            LOGGER.info("start to create RBAC headers for host: {}", (Object)host);
            ServiceCenterClient serviceCenterClient = (ServiceCenterClient)TokenCacheManager.this.serviceCenterClients.get(this.registryName);
            RbacTokenRequest request = new RbacTokenRequest();
            request.setName(this.accountName);
            request.setPassword(new String(this.cipher.decrypt(this.password.toCharArray())));
            RbacTokenResponse rbacTokenResponse = serviceCenterClient.queryToken(request, TokenCacheManager.INVALID_TOKEN);
            if (Response.Status.UNAUTHORIZED.getStatusCode() == rbacTokenResponse.getStatusCode() || Response.Status.FORBIDDEN.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                LOGGER.warn("username or password may be wrong, stop trying to query tokens.");
                return TokenCacheManager.INVALID_TOKEN;
            }
            if (Response.Status.NOT_FOUND.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                LOGGER.warn("service center do not support RBAC token, you should not config account info");
                return TokenCacheManager.INVALID_TOKEN;
            }
            if (Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() == rbacTokenResponse.getStatusCode()) {
                LOGGER.warn("service center query RBAC token error!");
                return null;
            }
            LOGGER.info("refresh host [{}] token successfully {}", (Object)host, (Object)rbacTokenResponse.getStatusCode());
            return rbacTokenResponse.getToken();
        }

        protected long refreshTime() {
            return 1200000L;
        }

        public String getToken(String host) {
            if (!this.enabled()) {
                return null;
            }
            String address = host;
            if (StringUtils.isEmpty((CharSequence)address)) {
                address = this.registryName;
            }
            try {
                return (String)this.cache.get((Object)address);
            }
            catch (Exception e) {
                LOGGER.error("failed to create token", (Throwable)e);
                return null;
            }
        }

        private boolean enabled() {
            return !StringUtils.isEmpty((CharSequence)this.accountName) && !StringUtils.isEmpty((CharSequence)this.password);
        }
    }
}

