/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MdnsDiscoveryConfiguration extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 12893;
  }

  // Properties.
  protected final PascalString mdnsServerName;
  protected final List<PascalString> serverCapabilities;

  public MdnsDiscoveryConfiguration(
      PascalString mdnsServerName, List<PascalString> serverCapabilities) {
    super();
    this.mdnsServerName = mdnsServerName;
    this.serverCapabilities = serverCapabilities;
  }

  public PascalString getMdnsServerName() {
    return mdnsServerName;
  }

  public List<PascalString> getServerCapabilities() {
    return serverCapabilities;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MdnsDiscoveryConfiguration");

    // Simple Field (mdnsServerName)
    writeSimpleField("mdnsServerName", mdnsServerName, writeComplex(writeBuffer));

    // Implicit Field (noOfServerCapabilities) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfServerCapabilities =
        (int) ((((getServerCapabilities()) == (null)) ? -(1) : COUNT(getServerCapabilities())));
    writeImplicitField(
        "noOfServerCapabilities", noOfServerCapabilities, writeSignedInt(writeBuffer, 32));

    // Array Field (serverCapabilities)
    writeComplexTypeArrayField("serverCapabilities", serverCapabilities, writeBuffer);

    writeBuffer.popContext("MdnsDiscoveryConfiguration");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MdnsDiscoveryConfiguration _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (mdnsServerName)
    lengthInBits += mdnsServerName.getLengthInBits();

    // Implicit Field (noOfServerCapabilities)
    lengthInBits += 32;

    // Array field
    if (serverCapabilities != null) {
      int i = 0;
      for (PascalString element : serverCapabilities) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= serverCapabilities.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("MdnsDiscoveryConfiguration");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString mdnsServerName =
        readSimpleField(
            "mdnsServerName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfServerCapabilities =
        readImplicitField("noOfServerCapabilities", readSignedInt(readBuffer, 32));

    List<PascalString> serverCapabilities =
        readCountArrayField(
            "serverCapabilities",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfServerCapabilities);

    readBuffer.closeContext("MdnsDiscoveryConfiguration");
    // Create the instance
    return new MdnsDiscoveryConfigurationBuilderImpl(mdnsServerName, serverCapabilities);
  }

  public static class MdnsDiscoveryConfigurationBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString mdnsServerName;
    private final List<PascalString> serverCapabilities;

    public MdnsDiscoveryConfigurationBuilderImpl(
        PascalString mdnsServerName, List<PascalString> serverCapabilities) {
      this.mdnsServerName = mdnsServerName;
      this.serverCapabilities = serverCapabilities;
    }

    public MdnsDiscoveryConfiguration build() {
      MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration =
          new MdnsDiscoveryConfiguration(mdnsServerName, serverCapabilities);
      return mdnsDiscoveryConfiguration;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MdnsDiscoveryConfiguration)) {
      return false;
    }
    MdnsDiscoveryConfiguration that = (MdnsDiscoveryConfiguration) o;
    return (getMdnsServerName() == that.getMdnsServerName())
        && (getServerCapabilities() == that.getServerCapabilities())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getMdnsServerName(), getServerCapabilities());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
