/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LightingDataOn extends LightingData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte group;

  public LightingDataOn(LightingCommandTypeContainer commandTypeContainer, byte group) {
    super(commandTypeContainer);
    this.group = group;
  }

  public byte getGroup() {
    return group;
  }

  @Override
  protected void serializeLightingDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LightingDataOn");

    // Simple Field (group)
    writeSimpleField("group", group, writeByte(writeBuffer, 8));

    writeBuffer.popContext("LightingDataOn");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LightingDataOn _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (group)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static LightingDataBuilder staticParseLightingDataBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("LightingDataOn");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte group = readSimpleField("group", readByte(readBuffer, 8));

    readBuffer.closeContext("LightingDataOn");
    // Create the instance
    return new LightingDataOnBuilderImpl(group);
  }

  public static class LightingDataOnBuilderImpl implements LightingData.LightingDataBuilder {
    private final byte group;

    public LightingDataOnBuilderImpl(byte group) {
      this.group = group;
    }

    public LightingDataOn build(LightingCommandTypeContainer commandTypeContainer) {
      LightingDataOn lightingDataOn = new LightingDataOn(commandTypeContainer, group);
      return lightingDataOn;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LightingDataOn)) {
      return false;
    }
    LightingDataOn that = (LightingDataOn) o;
    return (getGroup() == that.getGroup()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getGroup());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
