/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class IdentifyReplyCommandNetworkVoltage extends IdentifyReplyCommand implements Message {

  // Accessors for discriminator values.
  public Attribute getAttribute() {
    return Attribute.NetworkVoltage;
  }

  // Constant values.
  public static final Byte DOT = 0x2C;
  public static final Byte V = 0x56;

  // Properties.
  protected final String volts;
  protected final String voltsDecimalPlace;

  // Arguments.
  protected final Byte numBytes;

  public IdentifyReplyCommandNetworkVoltage(String volts, String voltsDecimalPlace, Byte numBytes) {
    super(numBytes);
    this.volts = volts;
    this.voltsDecimalPlace = voltsDecimalPlace;
    this.numBytes = numBytes;
  }

  public String getVolts() {
    return volts;
  }

  public String getVoltsDecimalPlace() {
    return voltsDecimalPlace;
  }

  public byte getDot() {
    return DOT;
  }

  public byte getV() {
    return V;
  }

  @Override
  protected void serializeIdentifyReplyCommandChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("IdentifyReplyCommandNetworkVoltage");

    // Simple Field (volts)
    writeSimpleField("volts", volts, writeString(writeBuffer, 16));

    // Const Field (dot)
    writeConstField("dot", DOT, writeByte(writeBuffer, 8));

    // Simple Field (voltsDecimalPlace)
    writeSimpleField("voltsDecimalPlace", voltsDecimalPlace, writeString(writeBuffer, 16));

    // Const Field (v)
    writeConstField("v", V, writeByte(writeBuffer, 8));

    writeBuffer.popContext("IdentifyReplyCommandNetworkVoltage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    IdentifyReplyCommandNetworkVoltage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (volts)
    lengthInBits += 16;

    // Const Field (dot)
    lengthInBits += 8;

    // Simple field (voltsDecimalPlace)
    lengthInBits += 16;

    // Const Field (v)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static IdentifyReplyCommandBuilder staticParseIdentifyReplyCommandBuilder(
      ReadBuffer readBuffer, Attribute attribute, Byte numBytes) throws ParseException {
    readBuffer.pullContext("IdentifyReplyCommandNetworkVoltage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    String volts = readSimpleField("volts", readString(readBuffer, 16));

    byte dot =
        readConstField("dot", readByte(readBuffer, 8), IdentifyReplyCommandNetworkVoltage.DOT);

    String voltsDecimalPlace = readSimpleField("voltsDecimalPlace", readString(readBuffer, 16));

    byte v = readConstField("v", readByte(readBuffer, 8), IdentifyReplyCommandNetworkVoltage.V);

    readBuffer.closeContext("IdentifyReplyCommandNetworkVoltage");
    // Create the instance
    return new IdentifyReplyCommandNetworkVoltageBuilderImpl(volts, voltsDecimalPlace, numBytes);
  }

  public static class IdentifyReplyCommandNetworkVoltageBuilderImpl
      implements IdentifyReplyCommand.IdentifyReplyCommandBuilder {
    private final String volts;
    private final String voltsDecimalPlace;
    private final Byte numBytes;

    public IdentifyReplyCommandNetworkVoltageBuilderImpl(
        String volts, String voltsDecimalPlace, Byte numBytes) {
      this.volts = volts;
      this.voltsDecimalPlace = voltsDecimalPlace;
      this.numBytes = numBytes;
    }

    public IdentifyReplyCommandNetworkVoltage build(Byte numBytes) {

      IdentifyReplyCommandNetworkVoltage identifyReplyCommandNetworkVoltage =
          new IdentifyReplyCommandNetworkVoltage(volts, voltsDecimalPlace, numBytes);
      return identifyReplyCommandNetworkVoltage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IdentifyReplyCommandNetworkVoltage)) {
      return false;
    }
    IdentifyReplyCommandNetworkVoltage that = (IdentifyReplyCommandNetworkVoltage) o;
    return (getVolts() == that.getVolts())
        && (getVoltsDecimalPlace() == that.getVoltsDecimalPlace())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getVolts(), getVoltsDecimalPlace());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
