/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_Submodule_InputData extends PnIoCm_Submodule implements Message {

  // Accessors for discriminator values.
  public PnIoCm_SubmoduleType getSubmoduleType() {
    return PnIoCm_SubmoduleType.INPUT_DATA;
  }

  // Constant values.
  public static final Integer INPUTDATADESCRIPTION = 0x0001;
  public static final Short INPUTLENGTHIOCS = 0x01;
  public static final Short INPUTLENGTHIOPS = 0x01;

  // Properties.
  protected final int inputSubmoduleDataLength;

  public PnIoCm_Submodule_InputData(
      int slotNumber,
      long submoduleIdentNumber,
      boolean discardIoxs,
      boolean reduceOutputModuleDataLength,
      boolean reduceInputModuleDataLength,
      boolean sharedInput,
      int inputSubmoduleDataLength) {
    super(
        slotNumber,
        submoduleIdentNumber,
        discardIoxs,
        reduceOutputModuleDataLength,
        reduceInputModuleDataLength,
        sharedInput);
    this.inputSubmoduleDataLength = inputSubmoduleDataLength;
  }

  public int getInputSubmoduleDataLength() {
    return inputSubmoduleDataLength;
  }

  public int getInputDataDescription() {
    return INPUTDATADESCRIPTION;
  }

  public short getInputLengthIoCs() {
    return INPUTLENGTHIOCS;
  }

  public short getInputLengthIoPs() {
    return INPUTLENGTHIOPS;
  }

  @Override
  protected void serializePnIoCm_SubmoduleChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_Submodule_InputData");

    // Const Field (inputDataDescription)
    writeConstField(
        "inputDataDescription",
        INPUTDATADESCRIPTION,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (inputSubmoduleDataLength)
    writeSimpleField(
        "inputSubmoduleDataLength",
        inputSubmoduleDataLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (inputLengthIoCs)
    writeConstField(
        "inputLengthIoCs",
        INPUTLENGTHIOCS,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (inputLengthIoPs)
    writeConstField(
        "inputLengthIoPs",
        INPUTLENGTHIOPS,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_Submodule_InputData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnIoCm_Submodule_InputData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (inputDataDescription)
    lengthInBits += 16;

    // Simple field (inputSubmoduleDataLength)
    lengthInBits += 16;

    // Const Field (inputLengthIoCs)
    lengthInBits += 8;

    // Const Field (inputLengthIoPs)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static PnIoCm_SubmoduleBuilder staticParsePnIoCm_SubmoduleBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_Submodule_InputData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int inputDataDescription =
        readConstField(
            "inputDataDescription",
            readUnsignedInt(readBuffer, 16),
            PnIoCm_Submodule_InputData.INPUTDATADESCRIPTION,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int inputSubmoduleDataLength =
        readSimpleField(
            "inputSubmoduleDataLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short inputLengthIoCs =
        readConstField(
            "inputLengthIoCs",
            readUnsignedShort(readBuffer, 8),
            PnIoCm_Submodule_InputData.INPUTLENGTHIOCS,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short inputLengthIoPs =
        readConstField(
            "inputLengthIoPs",
            readUnsignedShort(readBuffer, 8),
            PnIoCm_Submodule_InputData.INPUTLENGTHIOPS,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_Submodule_InputData");
    // Create the instance
    return new PnIoCm_Submodule_InputDataBuilderImpl(inputSubmoduleDataLength);
  }

  public static class PnIoCm_Submodule_InputDataBuilderImpl
      implements PnIoCm_Submodule.PnIoCm_SubmoduleBuilder {
    private final int inputSubmoduleDataLength;

    public PnIoCm_Submodule_InputDataBuilderImpl(int inputSubmoduleDataLength) {
      this.inputSubmoduleDataLength = inputSubmoduleDataLength;
    }

    public PnIoCm_Submodule_InputData build(
        int slotNumber,
        long submoduleIdentNumber,
        boolean discardIoxs,
        boolean reduceOutputModuleDataLength,
        boolean reduceInputModuleDataLength,
        boolean sharedInput) {
      PnIoCm_Submodule_InputData pnIoCm_Submodule_InputData =
          new PnIoCm_Submodule_InputData(
              slotNumber,
              submoduleIdentNumber,
              discardIoxs,
              reduceOutputModuleDataLength,
              reduceInputModuleDataLength,
              sharedInput,
              inputSubmoduleDataLength);
      return pnIoCm_Submodule_InputData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_Submodule_InputData)) {
      return false;
    }
    PnIoCm_Submodule_InputData that = (PnIoCm_Submodule_InputData) o;
    return (getInputSubmoduleDataLength() == that.getInputSubmoduleDataLength())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getInputSubmoduleDataLength());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
