/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InterfaceOptions1PowerUpSettings implements Message {

  // Properties.
  protected final InterfaceOptions1 interfaceOptions1;

  public InterfaceOptions1PowerUpSettings(InterfaceOptions1 interfaceOptions1) {
    super();
    this.interfaceOptions1 = interfaceOptions1;
  }

  public InterfaceOptions1 getInterfaceOptions1() {
    return interfaceOptions1;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InterfaceOptions1PowerUpSettings");

    // Simple Field (interfaceOptions1)
    writeSimpleField("interfaceOptions1", interfaceOptions1, writeComplex(writeBuffer));

    writeBuffer.popContext("InterfaceOptions1PowerUpSettings");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    InterfaceOptions1PowerUpSettings _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (interfaceOptions1)
    lengthInBits += interfaceOptions1.getLengthInBits();

    return lengthInBits;
  }

  public static InterfaceOptions1PowerUpSettings staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("InterfaceOptions1PowerUpSettings");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    InterfaceOptions1 interfaceOptions1 =
        readSimpleField(
            "interfaceOptions1",
            readComplex(() -> InterfaceOptions1.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("InterfaceOptions1PowerUpSettings");
    // Create the instance
    InterfaceOptions1PowerUpSettings _interfaceOptions1PowerUpSettings;
    _interfaceOptions1PowerUpSettings = new InterfaceOptions1PowerUpSettings(interfaceOptions1);
    return _interfaceOptions1PowerUpSettings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InterfaceOptions1PowerUpSettings)) {
      return false;
    }
    InterfaceOptions1PowerUpSettings that = (InterfaceOptions1PowerUpSettings) o;
    return (getInterfaceOptions1() == that.getInterfaceOptions1()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getInterfaceOptions1());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
