/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.AccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.registry.security.authorization.AuthorizationRequest;
import org.apache.nifi.registry.security.authorization.AuthorizationResult;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerInitializationContext;
import org.apache.nifi.registry.security.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.ManagedAuthorizer;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.util.PropertyValue;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandardManagedAuthorizer
implements ManagedAuthorizer {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String USER_GROUP_PROVIDER_ELEMENT = "userGroupProvider";
    private static final String ACCESS_POLICY_PROVIDER_ELEMENT = "accessPolicyProvider";
    private AccessPolicyProviderLookup accessPolicyProviderLookup;
    private AccessPolicyProvider accessPolicyProvider;
    private UserGroupProvider userGroupProvider;

    public StandardManagedAuthorizer() {
    }

    public StandardManagedAuthorizer(AccessPolicyProvider accessPolicyProvider, UserGroupProvider userGroupProvider) {
        this.accessPolicyProvider = accessPolicyProvider;
        this.userGroupProvider = userGroupProvider;
    }

    public void initialize(AuthorizerInitializationContext initializationContext) throws SecurityProviderCreationException {
        this.accessPolicyProviderLookup = initializationContext.getAccessPolicyProviderLookup();
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        PropertyValue accessPolicyProviderKey = configurationContext.getProperty("Access Policy Provider");
        if (!accessPolicyProviderKey.isSet()) {
            throw new SecurityProviderCreationException("The Access Policy Provider must be set.");
        }
        this.accessPolicyProvider = this.accessPolicyProviderLookup.getAccessPolicyProvider(accessPolicyProviderKey.getValue());
        if (this.accessPolicyProvider == null) {
            throw new SecurityProviderCreationException(String.format("Unable to locate configured Access Policy Provider: %s", accessPolicyProviderKey));
        }
        this.userGroupProvider = this.accessPolicyProvider.getUserGroupProvider();
        if (this.userGroupProvider == null) {
            throw new SecurityProviderCreationException(String.format("Configured Access Policy Provider %s does not contain a User Group Provider", accessPolicyProviderKey));
        }
    }

    public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
        String resourceIdentifier = request.getResource().getIdentifier();
        AccessPolicy policy = this.accessPolicyProvider.getAccessPolicy(resourceIdentifier, request.getAction());
        if (policy == null) {
            return AuthorizationResult.resourceNotFound();
        }
        UserAndGroups userAndGroups = this.userGroupProvider.getUserAndGroups(request.getIdentity());
        User user = userAndGroups.getUser();
        if (user == null) {
            return AuthorizationResult.denied((String)String.format("Unknown user with identity '%s'.", request.getIdentity()));
        }
        Set userGroups = userAndGroups.getGroups();
        if (policy.getUsers().contains(user.getIdentifier()) || this.containsGroup(userGroups, policy)) {
            return AuthorizationResult.approved();
        }
        return AuthorizationResult.denied((String)((String)request.getExplanationSupplier().get()));
    }

    private boolean containsGroup(Set<Group> userGroups, AccessPolicy policy) {
        if (userGroups == null || userGroups.isEmpty() || policy.getGroups().isEmpty()) {
            return false;
        }
        for (Group userGroup : userGroups) {
            if (!policy.getGroups().contains(userGroup.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public String getFingerprint() throws AuthorizationAccessException {
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("managedAuthorizations");
            writer.writeStartElement(ACCESS_POLICY_PROVIDER_ELEMENT);
            if (this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
                writer.writeCharacters(((ConfigurableAccessPolicyProvider)this.accessPolicyProvider).getFingerprint());
            }
            writer.writeEndElement();
            writer.writeStartElement(USER_GROUP_PROVIDER_ELEMENT);
            if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
                writer.writeCharacters(((ConfigurableUserGroupProvider)this.userGroupProvider).getFingerprint());
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (StringUtils.isBlank((CharSequence)fingerprint)) {
            return;
        }
        FingerprintHolder fingerprintHolder = this.parseFingerprint(fingerprint);
        if (StringUtils.isNotBlank((CharSequence)fingerprintHolder.getPolicyFingerprint()) && this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
            ((ConfigurableAccessPolicyProvider)this.accessPolicyProvider).inheritFingerprint(fingerprintHolder.getPolicyFingerprint());
        }
        if (StringUtils.isNotBlank((CharSequence)fingerprintHolder.getUserGroupFingerprint()) && this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ((ConfigurableUserGroupProvider)this.userGroupProvider).inheritFingerprint(fingerprintHolder.getUserGroupFingerprint());
        }
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        FingerprintHolder fingerprintHolder = this.parseFingerprint(proposedFingerprint);
        if (StringUtils.isNotBlank((CharSequence)fingerprintHolder.getPolicyFingerprint())) {
            if (this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
                ((ConfigurableAccessPolicyProvider)this.accessPolicyProvider).checkInheritability(fingerprintHolder.getPolicyFingerprint());
            } else {
                throw new UninheritableAuthorizationsException("Policy fingerprint is not blank and the configured AccessPolicyProvider does not support fingerprinting.");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fingerprintHolder.getUserGroupFingerprint())) {
            if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
                ((ConfigurableUserGroupProvider)this.userGroupProvider).checkInheritability(fingerprintHolder.getUserGroupFingerprint());
            } else {
                throw new UninheritableAuthorizationsException("User/Group fingerprint is not blank and the configured UserGroupProvider does not support fingerprinting.");
            }
        }
    }

    private final FingerprintHolder parseFingerprint(String fingerprint) throws AuthorizationAccessException {
        FingerprintHolder fingerprintHolder;
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);
        try {
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            Document document = documentProvider.parse((InputStream)in);
            Element rootElement = document.getDocumentElement();
            NodeList accessPolicyProviderList = rootElement.getElementsByTagName(ACCESS_POLICY_PROVIDER_ELEMENT);
            if (accessPolicyProviderList.getLength() != 1) {
                throw new AuthorizationAccessException(String.format("Only one %s element is allowed: %s", ACCESS_POLICY_PROVIDER_ELEMENT, fingerprint));
            }
            NodeList userGroupProviderList = rootElement.getElementsByTagName(USER_GROUP_PROVIDER_ELEMENT);
            if (userGroupProviderList.getLength() != 1) {
                throw new AuthorizationAccessException(String.format("Only one %s element is allowed: %s", USER_GROUP_PROVIDER_ELEMENT, fingerprint));
            }
            Node accessPolicyProvider = accessPolicyProviderList.item(0);
            Node userGroupProvider = userGroupProviderList.item(0);
            fingerprintHolder = new FingerprintHolder(accessPolicyProvider.getTextContent(), userGroupProvider.getTextContent());
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ProcessingException e) {
                throw new AuthorizationAccessException("Unable to parse fingerprint", e);
            }
        }
        in.close();
        return fingerprintHolder;
    }

    public AccessPolicyProvider getAccessPolicyProvider() {
        return this.accessPolicyProvider;
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    private static class FingerprintHolder {
        private final String policyFingerprint;
        private final String userGroupFingerprint;

        public FingerprintHolder(String policyFingerprint, String userGroupFingerprint) {
            this.policyFingerprint = policyFingerprint;
            this.userGroupFingerprint = userGroupFingerprint;
        }

        public String getPolicyFingerprint() {
            return this.policyFingerprint;
        }

        public String getUserGroupFingerprint() {
            return this.userGroupFingerprint;
        }
    }
}

