/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.PlaceholderReplacingReader;

public class SqlScriptMetadata {
    private static final Log LOG = LogFactory.getLog(SqlScriptMetadata.class);
    private static final String EXECUTE_IN_TRANSACTION = "executeInTransaction";
    private static final String ENCODING = "encoding";
    private static final String PLACEHOLDER_REPLACEMENT = "placeholderReplacement";
    private static final String SHOULD_EXECUTE = "shouldExecute";
    private final Boolean executeInTransaction;
    private final String encoding;
    private final Boolean placeholderReplacement;
    private String shouldExecuteExpression;
    private boolean shouldExecute;

    private SqlScriptMetadata(Map<String, String> metadata, Map<String, String> unmappedMetadata, Configuration config) {
        metadata = new HashMap<String, String>(metadata);
        this.executeInTransaction = ConfigUtils.removeBoolean(metadata, EXECUTE_IN_TRANSACTION);
        this.encoding = metadata.remove(ENCODING);
        this.placeholderReplacement = ConfigUtils.removeBoolean(metadata, PLACEHOLDER_REPLACEMENT);
        metadata.remove(PLACEHOLDER_REPLACEMENT);
        this.shouldExecute = true;
        this.shouldExecuteExpression = null;
        if (metadata.containsKey(SHOULD_EXECUTE)) {
            throw new FlywayEditionUpgradeRequiredException(Tier.TEAMS, LicenseGuard.getTier(config), SHOULD_EXECUTE);
        }
        ConfigUtils.checkConfigurationForUnrecognisedProperties(metadata, null);
    }

    public Boolean executeInTransaction() {
        return this.executeInTransaction;
    }

    public String encoding() {
        return this.encoding;
    }

    public Boolean placeholderReplacement() {
        return this.placeholderReplacement;
    }

    public boolean shouldExecute() {
        return this.shouldExecute;
    }

    public String shouldExecuteExpression() {
        return this.shouldExecuteExpression;
    }

    public static boolean isMultilineBooleanExpression(String line) {
        return !line.startsWith(SHOULD_EXECUTE) && (line.contains("==") || line.contains("!="));
    }

    public static SqlScriptMetadata fromResource(LoadableResource resource, Parser parser, Configuration config) {
        if (resource != null) {
            LOG.debug("Found script configuration: " + resource.getFilename());
            Map<String, String> unmappedMetadata = ConfigUtils.loadConfigurationFromReader(resource.read());
            if (parser == null) {
                return new SqlScriptMetadata(unmappedMetadata, unmappedMetadata, config);
            }
            Map<String, String> mappedMetadata = ConfigUtils.loadConfigurationFromReader(PlaceholderReplacingReader.create(parser.configuration, parser.parsingContext, resource.read()));
            return new SqlScriptMetadata(mappedMetadata, unmappedMetadata, parser.configuration);
        }
        return new SqlScriptMetadata(new HashMap<String, String>(), new HashMap<String, String>(), config);
    }

    public static LoadableResource getMetadataResource(ResourceProvider resourceProvider, LoadableResource resource) {
        if (resourceProvider == null) {
            return null;
        }
        return resourceProvider.getResource(resource.getRelativePath() + ".conf");
    }
}

