/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFMT
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MFMT.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        session.resetState();
        String argument = request.getArgument();
        if (argument == null || argument.trim().length() == 0) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "MFMT.invalid", null));
            return;
        }
        String[] arguments = argument.split(" ", 2);
        if (arguments.length != 2) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "MFMT.invalid", null));
            return;
        }
        String timestamp = arguments[0].trim();
        try {
            Date time = DateUtils.parseFTPDate(timestamp);
            String fileName = arguments[1].trim();
            FtpFile file = null;
            try {
                file = session.getFileSystemView().getFile(fileName);
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting the file object: {}", (Object)fileName, (Object)ex);
            }
            if (file == null || !file.doesExist()) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 550, "MFMT.filemissing", fileName));
                return;
            }
            if (!file.isFile()) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "MFMT.invalid", null));
                return;
            }
            if (!file.setLastModified(time.getTime())) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 450, "MFMT", fileName));
                return;
            }
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 213, "MFMT", "ModifyTime=" + timestamp + "; " + fileName));
            return;
        }
        catch (ParseException e) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "MFMT.invalid", null));
            return;
        }
    }
}

