/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class RandomInputStream
extends InputStream {
    private Random random = new Random();
    private boolean isClosed = false;
    private long size;
    private long bytesRead;

    public RandomInputStream(long size) {
        this.size = size;
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        long len = this.checkLimit(1L);
        if (len > 0L) {
            int result = this.random.nextInt() % 256;
            if (result < 0) {
                result = -result;
            }
            ++this.bytesRead;
            return result;
        }
        return -1;
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        this.checkOpen();
        int sizeToRead = (int)this.checkLimit(length);
        if (0 == sizeToRead) {
            return -1;
        }
        byte[] temp = new byte[sizeToRead];
        this.random.nextBytes(temp);
        System.arraycopy(temp, 0, data, offset, sizeToRead);
        this.bytesRead += (long)length;
        return length;
    }

    @Override
    public int read(byte[] data) throws IOException {
        this.checkOpen();
        long len = this.checkLimit(data.length);
        if (0L == len) {
            return -1;
        }
        this.random.nextBytes(data);
        this.bytesRead += len;
        return (int)len;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        this.checkOpen();
        long skip = this.checkLimit(bytesToSkip);
        this.bytesRead += skip;
        return skip;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public int available() {
        return (int)(this.size - this.bytesRead);
    }

    private void checkOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("RandomInputStream was already closed.");
        }
    }

    private long checkLimit(long sizeRequested) {
        if (this.bytesRead >= this.size) {
            return 0L;
        }
        if (this.bytesRead + sizeRequested >= this.size) {
            return this.size - this.bytesRead;
        }
        return sizeRequested;
    }
}

