/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlSchemaSerializer;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlSerializer;

public class HtmlSerializer
extends XmlSerializer
implements HtmlMetaProvider {
    public static final HtmlSerializer DEFAULT = new HtmlSerializer(HtmlSerializer.create());
    public static final HtmlSerializer DEFAULT_SQ = new Sq(HtmlSerializer.create());
    public static final HtmlSerializer DEFAULT_SQ_READABLE = new SqReadable(HtmlSerializer.create());
    public static final HtmlSerializer DEFAULT_SIMPLE_SQ = new HtmlSerializer(HtmlSerializer.create().sq().disableJsonTags());
    protected final boolean addBeanTypesHtml;
    protected final boolean addKeyValueTableHeaders;
    protected final boolean detectLabelParameters;
    protected final boolean detectLinksInStrings;
    protected final AnchorText uriAnchorText;
    protected final String labelParameter;
    private final Map<ClassMeta<?>, HtmlClassMeta> htmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, HtmlBeanPropertyMeta> htmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, HtmlBeanPropertyMeta>();
    private final AtomicReference<HtmlSchemaSerializer> schemaSerializer = new AtomicReference();

    public static Builder create() {
        return new Builder();
    }

    public HtmlSerializer(Builder builder) {
        super(builder);
        this.addBeanTypesHtml = builder.addBeanTypesHtml;
        this.addKeyValueTableHeaders = builder.addKeyValueTableHeaders;
        this.detectLabelParameters = !builder.disableDetectLabelParameters;
        this.detectLinksInStrings = !builder.disableDetectLinksInStrings;
        this.labelParameter = builder.labelParameter;
        this.uriAnchorText = builder.uriAnchorText;
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public HtmlSerializerSession.Builder createSession() {
        return HtmlSerializerSession.create(this);
    }

    @Override
    public HtmlBeanPropertyMeta getHtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return HtmlBeanPropertyMeta.DEFAULT;
        }
        HtmlBeanPropertyMeta m = this.htmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new HtmlBeanPropertyMeta(bpm.getDelegateFor(), this.getAnnotationProvider(), this);
            this.htmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public HtmlClassMeta getHtmlClassMeta(ClassMeta<?> cm) {
        HtmlClassMeta m = this.htmlClassMetas.get(cm);
        if (m == null) {
            m = new HtmlClassMeta(cm, this);
            this.htmlClassMetas.put(cm, m);
        }
        return m;
    }

    public HtmlSerializer getSchemaSerializer() {
        HtmlSchemaSerializer result = this.schemaSerializer.get();
        if (result == null && !this.schemaSerializer.compareAndSet(null, result = HtmlSchemaSerializer.create().beanContext(this.getBeanContext()).build())) {
            result = this.schemaSerializer.get();
        }
        return result;
    }

    @Override
    public HtmlSerializerSession getSession() {
        return this.createSession().build();
    }

    protected final String getLabelParameter() {
        return this.labelParameter;
    }

    protected final AnchorText getUriAnchorText() {
        return this.uriAnchorText;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypesHtml || super.isAddBeanTypes();
    }

    protected final boolean isAddKeyValueTableHeaders() {
        return this.addKeyValueTableHeaders;
    }

    protected final boolean isDetectLabelParameters() {
        return this.detectLabelParameters;
    }

    protected final boolean isDetectLinksInStrings() {
        return this.detectLinksInStrings;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a("addBeanTypesHtml", this.addBeanTypesHtml).a("addKeyValueTableHeaders", this.addKeyValueTableHeaders).a("detectLabelParameters", this.detectLabelParameters).a("detectLinksInStrings", this.detectLinksInStrings).a("labelParameter", this.labelParameter).a("uriAnchorText", (Object)this.uriAnchorText);
    }

    public static class Builder
    extends XmlSerializer.Builder {
        private static final Cache<HashKey, HtmlSerializer> CACHE = Cache.of(HashKey.class, HtmlSerializer.class).build();
        private boolean addBeanTypesHtml;
        private boolean addKeyValueTableHeaders;
        private boolean disableDetectLabelParameters;
        private boolean disableDetectLinksInStrings;
        private String labelParameter;
        private AnchorText uriAnchorText;

        protected Builder() {
            this.produces("text/html");
            this.addBeanTypesHtml = Utils.env("HtmlSerializer.addBeanTypesHtml", false);
            this.addKeyValueTableHeaders = Utils.env("HtmlSerializer.addKeyValueTableHeaders", false);
            this.disableDetectLabelParameters = Utils.env("HtmlSerializer.disableDetectLabelParameters", false);
            this.disableDetectLinksInStrings = Utils.env("HtmlSerializer.disableDetectLinksInStrings", false);
            this.uriAnchorText = Utils.env("HtmlSerializer.uriAnchorText", AnchorText.TO_STRING);
            this.labelParameter = Utils.env("HtmlSerializer.labelParameter", "label");
        }

        protected Builder(Builder copyFrom) {
            super(AssertionUtils.assertArgNotNull("copyFrom", copyFrom));
            this.addBeanTypesHtml = copyFrom.addBeanTypesHtml;
            this.addKeyValueTableHeaders = copyFrom.addKeyValueTableHeaders;
            this.disableDetectLabelParameters = copyFrom.disableDetectLabelParameters;
            this.disableDetectLinksInStrings = copyFrom.disableDetectLinksInStrings;
            this.labelParameter = copyFrom.labelParameter;
            this.uriAnchorText = copyFrom.uriAnchorText;
        }

        protected Builder(HtmlSerializer copyFrom) {
            super(AssertionUtils.assertArgNotNull("copyFrom", copyFrom));
            this.addBeanTypesHtml = copyFrom.addBeanTypesHtml;
            this.addKeyValueTableHeaders = copyFrom.addKeyValueTableHeaders;
            this.disableDetectLabelParameters = !copyFrom.detectLabelParameters;
            this.disableDetectLinksInStrings = !copyFrom.detectLinksInStrings;
            this.labelParameter = copyFrom.labelParameter;
            this.uriAnchorText = copyFrom.uriAnchorText;
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addBeanTypes(boolean value) {
            super.addBeanTypes(value);
            return this;
        }

        public Builder addBeanTypesHtml() {
            return this.addBeanTypesHtml(true);
        }

        public Builder addBeanTypesHtml(boolean value) {
            this.addBeanTypesHtml = value;
            return this;
        }

        @Override
        public Builder addBeanTypesXml() {
            super.addBeanTypesXml();
            return this;
        }

        @Override
        public Builder addBeanTypesXml(boolean value) {
            super.addBeanTypesXml(value);
            return this;
        }

        public Builder addKeyValueTableHeaders() {
            return this.addKeyValueTableHeaders(true);
        }

        public Builder addKeyValueTableHeaders(boolean value) {
            this.addKeyValueTableHeaders = value;
            return this;
        }

        @Override
        public Builder addNamespaceUrisToRoot() {
            super.addNamespaceUrisToRoot();
            return this;
        }

        @Override
        public Builder addNamespaceUrisToRoot(boolean value) {
            super.addNamespaceUrisToRoot(value);
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder addRootType(boolean value) {
            super.addRootType(value);
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public HtmlSerializer build() {
            return this.cache(CACHE).build(HtmlSerializer.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder defaultNamespace(Namespace value) {
            super.defaultNamespace(value);
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableAutoDetectNamespaces() {
            super.disableAutoDetectNamespaces();
            return this;
        }

        @Override
        public Builder disableAutoDetectNamespaces(boolean value) {
            super.disableAutoDetectNamespaces(value);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        public Builder disableDetectLabelParameters() {
            return this.disableDetectLabelParameters(true);
        }

        public Builder disableDetectLabelParameters(boolean value) {
            this.disableDetectLabelParameters = value;
            return this;
        }

        public Builder disableDetectLinksInStrings() {
            return this.disableDetectLinksInStrings(true);
        }

        public Builder disableDetectLinksInStrings(boolean value) {
            this.disableDetectLinksInStrings = value;
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public Builder disableJsonTags() {
            super.disableJsonTags();
            return this;
        }

        @Override
        public Builder disableJsonTags(boolean value) {
            super.disableJsonTags(value);
            return this;
        }

        @Override
        public Builder enableNamespaces() {
            super.enableNamespaces();
            return this;
        }

        @Override
        public Builder enableNamespaces(boolean value) {
            super.enableNamespaces(value);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(new Object[]{super.hashKey(), this.addBeanTypesHtml, this.addKeyValueTableHeaders, this.disableDetectLabelParameters, this.disableDetectLinksInStrings, this.labelParameter, this.uriAnchorText});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder keepNullProperties(boolean value) {
            super.keepNullProperties(value);
            return this;
        }

        public Builder labelParameter(String value) {
            this.labelParameter = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends SerializerListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder namespaces(Namespace ... values) {
            super.namespaces(values);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder ns() {
            super.ns();
            return this;
        }

        @Override
        public Builder produces(String value) {
            super.produces(value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder quoteCharOverride(char value) {
            super.quoteCharOverride(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortCollections(boolean value) {
            super.sortCollections(value);
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sortMaps(boolean value) {
            super.sortMaps(value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder textNodeDelimiter(String value) {
            super.textNodeDelimiter(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyCollections(boolean value) {
            super.trimEmptyCollections(value);
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimEmptyMaps(boolean value) {
            super.trimEmptyMaps(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        public Builder uriAnchorText(AnchorText value) {
            this.uriAnchorText = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder useWhitespace(boolean value) {
            super.useWhitespace(value);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }
    }

    public static class Sq
    extends HtmlSerializer {
        public Sq(Builder builder) {
            super(builder.quoteChar('\''));
        }
    }

    public static class SqReadable
    extends HtmlSerializer {
        public SqReadable(Builder builder) {
            super(builder.quoteChar('\'').useWhitespace());
        }
    }
}

