/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty;

import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.collections.Args;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.microservice.jetty.BasicJettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.BasicJettyServerFactory;
import org.apache.juneau.microservice.jetty.JettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.JettyServerFactory;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.servlet.RestServlet;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.utils.ManifestFile;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;

public class JettyMicroservice
extends Microservice {
    private static final String KEY_SERVLET_CONTEXT_HANDLER = "ServletContextHandler";
    private static volatile JettyMicroservice INSTANCE;
    final Messages messages = Messages.of(JettyMicroservice.class);
    private final Builder builder;
    final JettyMicroserviceListener listener;
    private final JettyServerFactory factory;
    volatile Server server;

    public static Builder create() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JettyMicroservice getInstance() {
        Class<JettyMicroservice> clazz = JettyMicroservice.class;
        synchronized (JettyMicroservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] args) throws Exception {
        JettyMicroservice.create().args(args).build().start().startConsole().join();
    }

    private static int findOpenPort(int[] ports) {
        int[] nArray = ports;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int port = nArray[n2];
            if (port == 0) {
                port = new Random().nextInt(Short.MAX_VALUE - ports[0] + 1) + ports[0];
            }
            ServerSocket ss = new ServerSocket(port);
            try {
                n3 = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ss.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    ++n2;
                }
            }
            ss.close();
            return n3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(JettyMicroservice m) {
        Class<JettyMicroservice> clazz = JettyMicroservice.class;
        synchronized (JettyMicroservice.class) {
            INSTANCE = m;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected JettyMicroservice(Builder builder) throws ParseException, IOException {
        super(builder);
        JettyMicroservice.setInstance(this);
        this.builder = builder.copy();
        this.listener = Utils.nn(builder.listener) ? builder.listener : new BasicJettyMicroserviceListener();
        this.factory = Utils.nn(builder.factory) ? builder.factory : new BasicJettyServerFactory();
    }

    public JettyMicroservice addServlet(Servlet servlet, String pathSpec) {
        ServletHolder sh = new ServletHolder(servlet);
        if (Utils.nn(pathSpec) && !((String)pathSpec).endsWith("/*")) {
            pathSpec = StringUtils.trimTrailingSlashes((String)pathSpec) + "/*";
        }
        this.getServletContextHandler().addServlet(sh, (String)pathSpec);
        return this;
    }

    public JettyMicroservice addServletAttribute(String name, Object value) {
        this.getServer().setAttribute(name, value);
        return this;
    }

    public Server createServer() throws ParseException, IOException, ExecutableException {
        this.listener.onCreateServer(this);
        Config cf = this.getConfig();
        ManifestFile mf = this.getManifest();
        VarResolver vr = this.getVarResolver();
        int[] ports = (int[])Utils.firstNonNull(this.builder.ports, cf.get("Jetty/port").as(int[].class).orElseGet(() -> mf.getWithDefault("Jetty-Port", CollectionUtils.ints(8000), int[].class)));
        int availablePort = JettyMicroservice.findOpenPort(ports);
        if (System.getProperty("availablePort") == null) {
            System.setProperty("availablePort", String.valueOf(availablePort));
        }
        String jettyXml = this.builder.jettyXml;
        String jettyConfig = cf.get("Jetty/config").orElse(mf.getString("Jetty-Config", "jetty.xml"));
        Boolean resolveVars = Utils.firstNonNull(this.builder.jettyXmlResolveVars, cf.get("Jetty/resolveVars").asBoolean().orElse(false));
        if (jettyXml == null) {
            jettyXml = IoUtils.loadSystemResourceAsString("jetty.xml", ".", "files");
        }
        if (jettyXml == null) {
            throw ThrowableUtils.rex("jetty.xml file ''{0}'' was not found on the file system or classpath.", jettyConfig);
        }
        if (resolveVars.booleanValue()) {
            jettyXml = vr.resolve(jettyXml);
        }
        this.getLogger().info(jettyXml);
        try {
            this.server = this.factory.create(jettyXml);
        }
        catch (Exception e2) {
            throw new ExecutableException(e2);
        }
        for (String s : cf.get("Jetty/servlets").asStringArray().orElse(new String[0])) {
            try {
                ClassInfoTyped<?> c = ReflectionUtils.info(Class.forName(s));
                if (!c.isChildOf(RestServlet.class)) {
                    throw ThrowableUtils.rex("Invalid servlet specified in Jetty/servlets.  Must be a subclass of RestServlet: {0}", s);
                }
                RestServlet rs = (RestServlet)((Object)c.newInstance());
                this.addServlet((Servlet)rs, rs.getPath());
            }
            catch (ClassNotFoundException e1) {
                throw new ExecutableException(e1);
            }
        }
        cf.get("Jetty/servletMap").asMap().orElse(JsonMap.EMPTY_MAP).forEach((k, v) -> {
            try {
                ClassInfoTyped<?> c = ReflectionUtils.info(Class.forName(v.toString()));
                if (!c.isChildOf(Servlet.class)) {
                    throw ThrowableUtils.rex("Invalid servlet specified in Jetty/servletMap.  Must be a subclass of Servlet: {0}", Utils.cn(v));
                }
                Servlet rs = (Servlet)c.newInstance();
                this.addServlet(rs, (String)k);
            }
            catch (ClassNotFoundException e1) {
                throw new ExecutableException(e1);
            }
        });
        cf.get("Jetty/servletAttributes").asMap().orElse(JsonMap.EMPTY_MAP).forEach(this::addServletAttribute);
        this.builder.servlets.forEach((k, v) -> this.addServlet((Servlet)v, (String)k));
        this.builder.servletAttributes.forEach(this::addServletAttribute);
        if (System.getProperty("juneau.serverPort") == null) {
            System.setProperty("juneau.serverPort", String.valueOf(availablePort));
        }
        return this.server;
    }

    public void destroyServer() throws Exception {
        if (Utils.nn(this.server)) {
            this.server.destroy();
        }
        this.server = null;
    }

    public String getContextPath() {
        return this.getServletContextHandler().getContextPath();
    }

    public String getHostName() {
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public int getPort() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            ServerConnector c2 = (ServerConnector)c;
            return c2.getPort();
        }
        throw new IllegalStateException("Could not locate ServerConnector in Jetty server.");
    }

    public String getProtocol() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            ServerConnector c2 = (ServerConnector)c;
            for (ConnectionFactory cf : c2.getConnectionFactories()) {
                if (!(cf instanceof SslConnectionFactory)) continue;
                return "https";
            }
        }
        return "http";
    }

    public Server getServer() {
        return Objects.requireNonNull(this.server, "Server not found.  createServer() must be called first.");
    }

    public ServletContextHandler getServletContextHandler() {
        Object obj = this.getServer().getAttribute(KEY_SERVLET_CONTEXT_HANDLER);
        if (obj instanceof ServletContextHandler) {
            ServletContextHandler obj2 = (ServletContextHandler)obj;
            return obj2;
        }
        throw new IllegalStateException("Servlet context handler not found in jetty server or at attribute 'ServletContextHandler'");
    }

    public URI getURI() {
        String cp = this.getContextPath();
        try {
            return new URI(this.getProtocol(), null, this.getHostName(), this.getPort(), "/".equals(cp) ? null : cp, null, null);
        }
        catch (URISyntaxException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    @Override
    public synchronized JettyMicroservice init() throws ParseException, IOException {
        super.init();
        return this;
    }

    @Override
    public JettyMicroservice join() throws Exception {
        this.server.join();
        return this;
    }

    @Override
    public synchronized JettyMicroservice start() throws Exception {
        super.start();
        this.createServer();
        this.startServer();
        return this;
    }

    @Override
    public synchronized JettyMicroservice startConsole() throws Exception {
        super.startConsole();
        return this;
    }

    @Override
    public synchronized JettyMicroservice stop() throws Exception {
        final Logger logger = this.getLogger();
        final Messages mb2 = this.messages;
        Thread t = new Thread("JettyMicroserviceStop"){

            @Override
            public void run() {
                try {
                    if (JettyMicroservice.this.server == null || JettyMicroservice.this.server.isStopping() || JettyMicroservice.this.server.isStopped()) {
                        return;
                    }
                    JettyMicroservice.this.listener.onStopServer(JettyMicroservice.this);
                    JettyMicroservice.this.out(mb2, "StoppingServer", new Object[0]);
                    JettyMicroservice.this.server.stop();
                    JettyMicroservice.this.out(mb2, "ServerStopped", new Object[0]);
                    JettyMicroservice.this.listener.onPostStopServer(JettyMicroservice.this);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, ThrowableUtils.lm(e), e);
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.stop();
        return this;
    }

    @Override
    public synchronized JettyMicroservice stopConsole() throws Exception {
        super.stopConsole();
        return this;
    }

    protected int startServer() throws Exception {
        this.listener.onStartServer(this);
        this.server.start();
        this.out(this.messages, "ServerStarted", this.getPort());
        this.listener.onPostStartServer(this);
        return this.getPort();
    }

    public static class Builder
    extends Microservice.Builder {
        String jettyXml;
        int[] ports;
        Boolean jettyXmlResolveVars;
        Map<String, Servlet> servlets = CollectionUtils.map();
        Map<String, Object> servletAttributes = CollectionUtils.map();
        JettyMicroserviceListener listener;
        JettyServerFactory factory;

        protected Builder() {
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.jettyXml = copyFrom.jettyXml;
            this.ports = copyFrom.ports;
            this.jettyXmlResolveVars = copyFrom.jettyXmlResolveVars;
            this.servlets = CollectionUtils.copyOf(copyFrom.servlets);
            this.servletAttributes = CollectionUtils.copyOf(copyFrom.servletAttributes);
            this.listener = copyFrom.listener;
        }

        @Override
        public Builder args(Args args) {
            super.args(args);
            return this;
        }

        @Override
        public Builder args(String ... args) {
            super.args(args);
            return this;
        }

        @Override
        public JettyMicroservice build() throws Exception {
            return new JettyMicroservice(this);
        }

        @Override
        public Builder config(Config config) {
            super.config(config);
            return this;
        }

        @Override
        public Builder configName(String configName) {
            super.configName(configName);
            return this;
        }

        @Override
        public Builder configStore(ConfigStore configStore) {
            super.configStore(configStore);
            return this;
        }

        @Override
        public Builder console(Scanner consoleReader, PrintWriter consoleWriter) {
            super.console(consoleReader, consoleWriter);
            return this;
        }

        @Override
        public Builder consoleCommands(ConsoleCommand ... consoleCommands) {
            super.consoleCommands(consoleCommands);
            return this;
        }

        @Override
        public Builder consoleEnabled(boolean consoleEnabled) {
            super.consoleEnabled(consoleEnabled);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        public Builder jettyServerFactory(JettyServerFactory value) {
            this.factory = value;
            return this;
        }

        public Builder jettyXml(Object jettyXml, boolean resolveVars) throws IOException {
            if (jettyXml instanceof String) {
                String jettyXml2 = (String)jettyXml;
                this.jettyXml = IoUtils.read(this.resolveFile(jettyXml2.toString()));
            } else if (jettyXml instanceof File) {
                File jettyXml3 = (File)jettyXml;
                this.jettyXml = IoUtils.read(jettyXml3);
            } else if (jettyXml instanceof Path) {
                Path jettyXml4 = (Path)jettyXml;
                this.jettyXml = IoUtils.read(jettyXml4);
            } else if (jettyXml instanceof InputStream) {
                InputStream jettyXml5 = (InputStream)jettyXml;
                this.jettyXml = IoUtils.read(jettyXml5);
            } else if (jettyXml instanceof Reader) {
                Reader jettyXml6 = (Reader)jettyXml;
                this.jettyXml = IoUtils.read(jettyXml6);
            } else {
                throw ThrowableUtils.rex("Invalid object type passed to jettyXml(Object): {0}", Utils.cn(jettyXml));
            }
            this.jettyXmlResolveVars = resolveVars;
            return this;
        }

        public Builder listener(JettyMicroserviceListener listener) {
            super.listener(listener);
            this.listener = listener;
            return this;
        }

        @Override
        public Builder logger(Logger logger) {
            super.logger(logger);
            return this;
        }

        @Override
        public Builder manifest(Object manifest) throws IOException {
            super.manifest(manifest);
            return this;
        }

        public Builder ports(int ... ports) {
            this.ports = ports;
            return this;
        }

        public Builder servlet(Class<? extends RestServlet> c) throws ExecutableException {
            RestServlet rs;
            try {
                rs = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ExecutableException(e);
            }
            return this.servlet((Servlet)rs, "/" + rs.getPath());
        }

        public Builder servlet(Class<? extends Servlet> c, String path) throws ExecutableException {
            try {
                return this.servlet(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), path);
            }
            catch (Exception e) {
                throw new ExecutableException(e);
            }
        }

        public Builder servlet(Servlet servlet, String path) {
            this.servlets.put(path, servlet);
            return this;
        }

        public Builder servletAttribute(Map<String, Object> values) {
            if (Utils.nn(values)) {
                this.servletAttributes.putAll(values);
            }
            return this;
        }

        public Builder servletAttribute(String name, Object value) {
            this.servletAttributes.put(name, value);
            return this;
        }

        public Builder servlets(Map<String, Servlet> servlets) {
            if (Utils.nn(servlets)) {
                this.servlets.putAll(servlets);
            }
            return this;
        }

        @Override
        public <T> Builder varBean(Class<T> c, T value) {
            super.varBean(c, value);
            return this;
        }

        @Override
        public Builder vars(Class<? extends Var> ... vars) {
            super.vars(vars);
            return this;
        }

        @Override
        public Builder workingDir(File path) {
            super.workingDir(path);
            return this;
        }

        @Override
        public Builder workingDir(String path) {
            super.workingDir(path);
            return this;
        }
    }
}

