/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicBooleanPart
extends BasicPart {
    private final Boolean value;
    private final Supplier<Boolean> supplier;

    public static BasicBooleanPart of(String name, Boolean value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicBooleanPart(name, value);
    }

    public static BasicBooleanPart of(String name, Supplier<Boolean> value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicBooleanPart(name, value);
    }

    public BasicBooleanPart(String name, Boolean value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicBooleanPart(String name, String value) {
        super(name, value);
        this.value = Utils.e(value) ? null : Boolean.valueOf(Utils.bool(value));
        this.supplier = null;
    }

    public BasicBooleanPart(String name, Supplier<Boolean> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public Optional<Boolean> asBoolean() {
        return Utils.opt(this.toBoolean());
    }

    public FluentBooleanAssertion<BasicBooleanPart> assertBoolean() {
        return new FluentBooleanAssertion<BasicBooleanPart>(this.value(), this);
    }

    @Override
    public String getValue() {
        return Utils.s(this.value());
    }

    public Boolean orElse(Boolean other) {
        Boolean x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public Boolean toBoolean() {
        return this.value();
    }

    private Boolean value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

