/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.Writer;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.svl.VarResolverSession;

public abstract class Var {
    private final String name;
    final boolean streamed;

    public Var(String name, boolean streamed) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        this.name = name;
        this.streamed = streamed;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
            throw ThrowableUtils.illegalArg((String)"Invalid var name.  Must consist of only uppercase and lowercase ASCII letters.", (Object[])new Object[0]);
        }
    }

    public abstract String resolve(VarResolverSession var1, String var2) throws Exception;

    public abstract void resolveTo(VarResolverSession var1, Writer var2, String var3) throws Exception;

    protected boolean allowNested() {
        return true;
    }

    protected boolean allowRecurse() {
        return true;
    }

    protected boolean canResolve(VarResolverSession session) {
        return true;
    }

    protected String doResolve(VarResolverSession session, String arg) throws Exception {
        return this.resolve(session, arg);
    }

    protected String getName() {
        return this.name;
    }
}

