/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.jsonld;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class TitaniumToJena {
    public static void convert(Document document, JsonLdOptions opts, StreamRDF output, ParserProfile profile) throws JsonLdError {
        JsonLDToStreamRDF consumer = new JsonLDToStreamRDF(output, profile);
        JsonLd.toRdf(document).options(opts).provide(consumer);
    }

    static class JsonLDToStreamRDF
    implements RdfQuadConsumer {
        private static final long line = -1L;
        private static final long col = -1L;
        private final StreamRDF output;
        private final ParserProfile profile;

        JsonLDToStreamRDF(StreamRDF output, ParserProfile profile) {
            this.output = output;
            this.profile = profile;
        }

        @Override
        public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
            Node g = graph == null ? null : this.convertToNode(graph);
            Node s = this.convertToNode(subject);
            Node p = this.convertToNode(predicate);
            Node o = RdfQuadConsumer.isLiteral(datatype, language, direction) ? this.convertToLiteral(object, datatype, language, direction) : this.convertToNode(object);
            if (g == null) {
                this.output.triple(Triple.create(s, p, o));
            } else {
                this.output.quad(Quad.create(g, s, p, o));
            }
            return this;
        }

        private Node convertToNode(String str2) {
            if (RdfQuadConsumer.isBlank(str2)) {
                str2 = str2.substring(2);
                return this.profile.getFactorRDF().createBlankNode(str2);
            }
            str2 = this.profile.resolveIRI(str2, -1L, -1L);
            return this.profile.createURI(str2, -1L, -1L);
        }

        private Node convertToLiteral(String lexical, String datatypeURI, String language, String direction) {
            if (RdfQuadConsumer.isLangString(datatypeURI, language, direction)) {
                return this.profile.createLangLiteral(lexical, language, -1L, -1L);
            }
            if (RdfQuadConsumer.isDirLangString(datatypeURI, language, direction)) {
                return this.profile.createLangDirLiteral(lexical, language, direction, -1L, -1L);
            }
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            return this.profile.createTypedLiteral(lexical, dType, -1L, -1L);
        }
    }
}

