/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.main.solver.SolverRX3;
import org.apache.jena.sparql.engine.main.solver.StageMatchData;
import org.apache.jena.sparql.engine.main.solver.StageMatchTriple;

public class SolverRX4 {
    public static final boolean DATAPATH = true;
    private static final Predicate<Quad> NoFilter = null;
    private static final boolean NoAnyGraph = false;

    public static Iterator<Binding> rdfStarQuad(Iterator<Binding> chain, Quad pattern, ExecutionContext execCxt) {
        return SolverRX4.rdfStarQuad(chain, pattern.getGraph(), pattern.asTriple(), execCxt);
    }

    public static Iterator<Binding> rdfStarQuad(Iterator<Binding> chain, Node graphName, Triple pattern, ExecutionContext execCxt) {
        if (!(SolverLib.tripleHasEmbTripleWithVars(pattern) || graphName != null && graphName.isTripleTerm())) {
            return SolverRX4.matchDataQuad(chain, graphName, pattern, execCxt);
        }
        return SolverRX4.rdfStarQuadSub(chain, graphName, pattern, execCxt);
    }

    private static Iterator<Binding> rdfStarQuadSub(Iterator<Binding> chain, Node graphName, Triple pattern, ExecutionContext execCxt) {
        Iterator<Binding> matches = Iter.flatMap(chain, binding -> SolverRX4.rdfStarQuadSub(binding, graphName, pattern, execCxt));
        return matches;
    }

    private static Iterator<Binding> rdfStarQuadSub(Binding binding, Node xGraphName, Triple xPattern, ExecutionContext execCxt) {
        Triple tPattern = Substitute.substitute(xPattern, binding);
        Node graphName = Substitute.substitute(xGraphName, binding);
        Node g = graphName == null ? Quad.defaultGraphIRI : SolverLib.nodeTopLevel(graphName);
        Node s = SolverLib.nodeTopLevel(tPattern.getSubject());
        Node p = SolverLib.nodeTopLevel(tPattern.getPredicate());
        Node o = SolverLib.nodeTopLevel(tPattern.getObject());
        DatasetGraph dsg = execCxt.getDataset();
        Iterator<Quad> dataIter = dsg.find(g, s, p, o);
        Iterator<Binding> matched = Iter.map(dataIter, qData -> SolverRX4.matchQuad(binding, qData, g, tPattern));
        return Iter.removeNulls(matched);
    }

    private static Iterator<Binding> matchDataQuad(Iterator<Binding> chain, Node graphName, Triple pattern, ExecutionContext execCxt) {
        Iterator<Binding> matches = StageMatchData.accessQuad(chain, graphName, pattern, NoFilter, false, execCxt);
        return matches;
    }

    private static Iterator<Binding> matchData(Iterator<Binding> chain, Triple pattern, ExecutionContext execCxt) {
        Graph g = execCxt.getActiveGraph();
        Iterator<Binding> iter = StageMatchTriple.accessTriple(chain, g, pattern, null, execCxt);
        return iter;
    }

    public static Binding matchQuad(Binding input, Quad qData, Node tGraphNode, Triple tPattern) {
        BindingBuilder bb = Binding.builder(input);
        boolean r = SolverRX4.matchQuad(bb, qData, tGraphNode, tPattern);
        return r ? bb.build() : null;
    }

    private static boolean matchQuad(BindingBuilder bb, Quad qData, Node tGraphNode, Triple tPattern) {
        Node sPattern = tPattern.getSubject();
        Node pPattern = tPattern.getPredicate();
        Node oPattern = tPattern.getObject();
        Node gData = qData.getGraph();
        Node sData = qData.getSubject();
        Node pData = qData.getPredicate();
        Node oData = qData.getObject();
        if (!SolverRX4.match(bb, gData, tGraphNode)) {
            return false;
        }
        if (!SolverRX4.match(bb, sData, sPattern)) {
            return false;
        }
        if (!SolverRX4.match(bb, pData, pPattern)) {
            return false;
        }
        return SolverRX4.match(bb, oData, oPattern);
    }

    private static boolean match(BindingBuilder bb, Node nData, Node nPattern) {
        if (nPattern == null) {
            return true;
        }
        if (nData == Node.ANY) {
            return true;
        }
        if ((nPattern = Var.lookup(v -> bb.get((Var)v), nPattern)).isConcrete()) {
            return SolverLib.sameTermAs(nData, nPattern);
        }
        if (Var.isVar(nPattern)) {
            Var var = Var.alloc(nPattern);
            bb.add(var, nData);
            return true;
        }
        if (!nData.isTripleTerm()) {
            return false;
        }
        Triple tPattern = nPattern.getTriple();
        Triple tData = nData.getTriple();
        return SolverRX3.bindTriple(bb, tData, tPattern);
    }
}

