/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.cache.CacheOps;

public class CachePlainLRU<K, V>
implements Cache<K, V> {
    private final Map<K, V> cache;
    private final float loadFactor = 0.75f;
    private final float initialCapacityFactory = 0.75f;

    public CachePlainLRU(final int maxCapacity) {
        int initialCapacity = (int)((float)maxCapacity / 0.75f + 1.0f);
        this.cache = new LinkedHashMap<K, V>(initialCapacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxCapacity;
            }
        };
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V getIfPresent(K key) {
        return this.cache.get(key);
    }

    @Override
    public V get(K key, Function<K, V> function) {
        return CacheOps.getOrFill(this, key, function);
    }

    @Override
    public void put(K key, V thing) {
        this.cache.put(key, thing);
    }

    @Override
    public void remove(K key) {
        this.remove(key);
    }

    @Override
    public Iterator<K> keys() {
        return this.cache.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public void clear() {
    }

    @Override
    public long size() {
        return 0L;
    }
}

