/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;

class LibRDFConn {
    private static String dftName = "default";

    LibRDFConn() {
    }

    static boolean isDefault(String name) {
        return name == null || name.equals(dftName);
    }

    static RDFConnection adapt(RDFLink link) {
        return RDFConnectionAdapter.adapt(link);
    }

    private static String queryStringForGraph(String ch, String graphName) {
        return ch + (String)(LibRDFConn.isDefault(graphName) ? "default" : "graph=" + graphName);
    }

    static String urlForGraph(String graphStoreProtocolService, String graphName) {
        String ch = "?";
        if (graphStoreProtocolService.contains("?")) {
            ch = "&";
        }
        return graphStoreProtocolService + LibRDFConn.queryStringForGraph(ch, graphName);
    }

    static String formServiceURL(String destination, String srvEndpoint) {
        if (srvEndpoint == null) {
            return null;
        }
        if (srvEndpoint == RDFConnectionRemoteBuilder.SameAsDestination) {
            return destination;
        }
        if (destination == null) {
            return srvEndpoint;
        }
        if (srvEndpoint.startsWith("http:/") || srvEndpoint.startsWith("https:/")) {
            return srvEndpoint;
        }
        String queryString = null;
        Object dest = destination;
        if (destination.contains("?")) {
            int i = destination.indexOf(63);
            queryString = destination.substring(i);
            dest = destination.substring(0, i);
        }
        if (((String)dest).endsWith("/")) {
            dest = ((String)dest).substring(0, ((String)dest).length() - 1);
        }
        dest = (String)dest + "/" + srvEndpoint;
        if (queryString != null) {
            dest = (String)dest + queryString;
        }
        return dest;
    }
}

