/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.builders.BuilderLib;

public class BuilderPrefixMapping {
    public static PrefixMapping build(Item elt) {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        BuilderPrefixMapping.build((PrefixMapping)pmap, elt);
        return pmap;
    }

    public static void build(PrefixMapping newMappings, Item elt) {
        if (!elt.isList()) {
            BuilderLib.broken((ItemLocation)elt, "Prefix mapping requires a list of pairs", elt);
        }
        ItemList prefixes = elt.getList();
        if (elt.isTaggedIgnoreCase("prefixmap") || elt.isTaggedIgnoreCase("prefixmapping")) {
            BuilderLib.checkLength(2, elt.getList(), "Not of length 2" + elt.shortString());
            prefixes = prefixes.cdr();
        }
        for (Item pair : prefixes) {
            Node iriNode;
            if (!pair.isList() || pair.getList().size() != 2) {
                BuilderLib.broken(pair, "Not a prefix/IRI pair");
            }
            Item prefixItem = pair.getList().get(0);
            Item iriItem = pair.getList().get(1);
            String prefix = null;
            if (prefixItem.isSymbol()) {
                prefix = prefixItem.getSymbol();
            }
            if (prefix == null) {
                BuilderLib.broken(pair, "Prefix part not recognized: " + String.valueOf(prefixItem));
            }
            if (!prefix.endsWith(":")) {
                BuilderLib.broken(pair, "Prefix part does not end with a ':': " + String.valueOf(pair));
            }
            if (StrUtils.contains((String)(prefix = prefix.substring(0, prefix.length() - 1)), (String)":")) {
                BuilderLib.broken(pair, "Prefix itself contains a ':' : " + String.valueOf(pair));
            }
            if ((iriNode = iriItem.getNode()) == null || !iriNode.isURI()) {
                BuilderLib.broken(pair, "Not an IRI: " + String.valueOf(iriItem));
            }
            String iri = iriNode.getURI();
            newMappings.setNsPrefix(prefix, iri);
        }
    }
}

