/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path.eval;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.eval.PathEngine;

final class PathEngineN
extends PathEngine {
    private boolean forwardMode;

    public PathEngineN(Graph graph, boolean forward) {
        super(graph, null);
        this.forwardMode = forward;
    }

    protected Set<Node> visitedAcc() {
        return new HashSet<Node>();
    }

    @Override
    protected void flipDirection() {
        this.forwardMode = !this.forwardMode;
    }

    @Override
    protected boolean direction() {
        return this.forwardMode;
    }

    @Override
    protected void doNegatedPropertySet(P_NegPropSet pathNotOneOf, Node node, Collection<Node> output) {
        if (pathNotOneOf.getFwdNodes().size() > 0) {
            Iterator<Node> nodes1 = this.stepExcludeForwards(node, pathNotOneOf.getFwdNodes());
            this.fill(nodes1, output);
        }
        if (pathNotOneOf.getBwdNodes().size() > 0) {
            Iterator<Node> nodes2 = this.stepExcludeBackwards(node, pathNotOneOf.getBwdNodes());
            this.fill(nodes2, output);
        }
    }

    @Override
    protected void doAlt(Path pathStepLeft, Path pathStepRight, Node node, Collection<Node> output) {
        Iter<Node> iter = this.eval(pathStepLeft, node);
        this.fill((Iterator<Node>)iter, output);
        iter = this.eval(pathStepRight, node);
        this.fill((Iterator<Node>)iter, output);
    }

    @Override
    protected void doSeq(Path pathStepLeft, Path pathStepRight, Node node, Collection<Node> output) {
        Path part1 = this.forwardMode ? pathStepLeft : pathStepRight;
        Path part2 = this.forwardMode ? pathStepRight : pathStepLeft;
        Iter<Node> iter = this.eval(part1, node);
        iter.forEachRemaining(n -> this.eval(part2, (Node)n, output));
    }

    @Override
    protected void doMultiLengthPath(Path pathStep, Node node, long min1, long max1, Collection<Node> output) {
        if (min1 == -1L) {
            min1 = 0L;
        }
        if (min1 == 0L) {
            output.add(node);
        }
        if (max1 == 0L) {
            return;
        }
        long min2 = PathEngineN.dec(min1);
        long max2 = PathEngineN.dec(max1);
        Path p1 = pathStep;
        Path p2 = new P_Mod(pathStep, min2, max2);
        if (!this.forwardMode) {
            Path tmp = p1;
            p1 = p2;
            p2 = tmp;
        }
        Iter<Node> iter = this.eval(p1, node);
        while (iter.hasNext()) {
            Node n2 = (Node)iter.next();
            Iter<Node> iter2 = this.eval(p2, n2);
            this.fill((Iterator<Node>)iter2, output);
        }
    }

    @Override
    protected void doFixedLengthPath(Path pathStep, Node node, long fixedLength, Collection<Node> output) {
        if (fixedLength == 0L) {
            output.add(node);
            return;
        }
        Iter<Node> iter = this.eval(pathStep, node);
        long count2 = PathEngineN.dec(fixedLength);
        P_FixedLength nextPath = new P_FixedLength(pathStep, count2);
        while (iter.hasNext()) {
            Node n2 = (Node)iter.next();
            Iter<Node> iter2 = this.eval(nextPath, n2);
            this.fill((Iterator<Node>)iter2, output);
        }
    }

    @Override
    protected void doZeroOrOne(Path pathStep, Node node, Collection<Node> output) {
        this.doZero(pathStep, node, output);
        this.doOne(pathStep, node, output);
    }

    private void doOne(Path path, Node node, Collection<Node> output) {
        Iter<Node> iter = this.eval(path, node);
        this.fill((Iterator<Node>)iter, output);
    }

    @Override
    protected void doZero(Path path, Node node, Collection<Node> output) {
        output.add(node);
    }

    @Override
    protected void doZeroOrMore(Path path, Node node, Collection<Node> output) {
        Set<Node> visited = this.visitedAcc();
        this.ALP(node, path, visited, output);
    }

    @Override
    protected void doOneOrMore(Path path, Node node, Collection<Node> output) {
        Set<Node> visited = this.visitedAcc();
        Iter<Node> iter1 = this.eval(path, node);
        while (iter1.hasNext()) {
            Node n1 = (Node)iter1.next();
            this.ALP(n1, path, visited, output);
        }
    }

    private void ALP(Node node, Path path, Set<Node> visited, Collection<Node> output) {
        if (visited.contains(node)) {
            return;
        }
        if (!output.add(node)) {
            return;
        }
        visited.add(node);
        Iter<Node> iter1 = this.eval(path, node);
        while (iter1.hasNext()) {
            Node n1 = (Node)iter1.next();
            this.ALP(n1, path, visited, output);
        }
        visited.remove(node);
    }
}

