/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SMono$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001B\b\u0011\u0001uA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003J\u0001\u0011\u0005!\nC\u0003V\u0001\u0011\u0005c\u000bC\u0003V\u0001\u0011\u0005c\u000f\u0003\u0004V\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\r\u0001\t\u0003\n)\u0004C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H!9\u0011Q\u000b\u0001\u0005B\u0005]\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0002\u0015!\u0006\u001c8\u000f\u00165s_V<\u0007N\u00117pEN#xN]3\u000b\u0005E\u0011\u0012!\u00043fIV\u0004H.[2bi&|gN\u0003\u0002\u0014)\u0005!!\r\\8c\u0015\t)b#\u0001\u0004tKJ4XM\u001d\u0006\u0003/a\tQA[1nKNT!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011c\u0001\u0001\u001fMA\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005Y\u0006twMC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#AB(cU\u0016\u001cG\u000f\u0005\u0002(W5\t\u0001F\u0003\u0002*U\u0005\u0019\u0011\r]5\u000b\u0005M1\u0012B\u0001\u0017)\u0005%\u0011En\u001c2Ti>\u0014X-\u0001\u0007cY>\u00147\u000b^8sK\u0012\u000bu\n\u0005\u0002(_%\u0011\u0001\u0007\u000b\u0002\r\u00052|'m\u0015;pe\u0016$\u0015iT\u0001\u0012I\u00164\u0017-\u001e7u\u0005V\u001c7.\u001a;OC6,\u0007CA\u00144\u0013\t!\u0004F\u0001\u0006Ck\u000e\\W\r\u001e(b[\u0016DCA\u0001\u001c?\u007fA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0007S:TWm\u0019;\u000b\u0003m\nQA[1wCbL!!\u0010\u001d\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003\u0001\u000bQ\u0002Z3gCVdGOQ;dW\u0016$\u0018!\u00042m_\nLEMR1di>\u0014\u0018\u0010\u0005\u0002D\r:\u0011q\u0005R\u0005\u0003\u000b\"\naA\u00117pE&#\u0017BA$I\u0005\u001d1\u0015m\u0019;pefT!!\u0012\u0015\u0002\rqJg.\u001b;?)\u0011YUJ\u0014)\u0011\u00051\u0003Q\"\u0001\t\t\u000b5\"\u0001\u0019\u0001\u0018\t\u000bE\"\u0001\u0019\u0001\u001a)\t93dh\u0010\u0005\u0006\u0003\u0012\u0001\rA\u0011\u0015\u0003\tI\u0003\"aN*\n\u0005QC$AB%oU\u0016\u001cG/\u0001\u0003tCZ,G\u0003B,aE6\u00042\u0001W.^\u001b\u0005I&B\u0001.\u001b\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018B\u0001/Z\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002(=&\u0011q\f\u000b\u0002\u0007\u00052|'-\u00133\t\u000b\u0005,\u0001\u0019\u0001\u001a\u0002\u0015\t,8m[3u\u001d\u0006lW\rC\u0003d\u000b\u0001\u0007A-\u0001\u0003eCR\f\u0007cA3iU6\taMC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIgMA\u0003BeJ\f\u0017\u0010\u0005\u0002fW&\u0011AN\u001a\u0002\u0005\u0005f$X\rC\u0003o\u000b\u0001\u0007q.A\u0007ti>\u0014\u0018mZ3Q_2L7-\u001f\t\u0003aNt!aJ9\n\u0005ID\u0013!\u0003\"m_\n\u001cFo\u001c:f\u0013\t!XOA\u0007Ti>\u0014\u0018mZ3Q_2L7-\u001f\u0006\u0003e\"\"BaV<y\u007f\")\u0011M\u0002a\u0001e!)1M\u0002a\u0001sB\u0011!0`\u0007\u0002w*\u0011API\u0001\u0003S>L!A`>\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006]\u001a\u0001\ra\u001c\u000b\b/\u0006\r\u0011QAA\u000f\u0011\u0015\tw\u00011\u00013\u0011\u0019\u0019w\u00011\u0001\u0002\bA!\u0011\u0011BA\r\u001b\t\tYAC\u0002}\u0003\u001bQA!a\u0004\u0002\u0012\u000511m\\7n_:TA!a\u0005\u0002\u0016\u00051qm\\8hY\u0016T!!a\u0006\u0002\u0007\r|W.\u0003\u0003\u0002\u001c\u0005-!A\u0003\"zi\u0016\u001cv.\u001e:dK\")an\u0002a\u0001_\u0006I!/Z1e\u0005f$Xm\u001d\u000b\u0007\u0003G\t)#a\n\u0011\u0007a[F\rC\u0003b\u0011\u0001\u0007!\u0007\u0003\u0004\u0002*!\u0001\r!X\u0001\u0007E2|'-\u00133\u0002\tI,\u0017\r\u001a\u000b\u0006s\u0006=\u0012\u0011\u0007\u0005\u0006C&\u0001\rA\r\u0005\u0007\u0003SI\u0001\u0019A/\u0002)\u001d,G\u000fR3gCVdGOQ;dW\u0016$h*Y7f)\u0005\u0011\u0014\u0001\u00043fY\u0016$XMQ;dW\u0016$H\u0003BA\u001e\u0003\u0007\u0002B\u0001W.\u0002>A\u0019q$a\u0010\n\u0007\u0005\u0005\u0003E\u0001\u0003W_&$\u0007\"B1\f\u0001\u0004\u0011\u0014A\u00023fY\u0016$X\r\u0006\u0004\u0002J\u0005E\u00131\u000b\t\u00051n\u000bY\u0005E\u0002 \u0003\u001bJ1!a\u0014!\u0005\u001d\u0011un\u001c7fC:DQ!\u0019\u0007A\u0002IBa!!\u000b\r\u0001\u0004i\u0016a\u00037jgR\u0014UoY6fiN$\"!!\u0017\u0011\u0007a[&'A\u0005mSN$(\t\\8cgR\u0019q+a\u0018\t\u000b\u0005t\u0001\u0019\u0001\u001a")
public class PassThroughBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public Publisher<BlobId> save(BucketName x$1, String x$2, BlobStore.StoragePolicy x$3) {
        return super.save(x$1, x$2, x$3);
    }

    public Publisher<byte[]> readBytes(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readBytes(x$1, x$2, x$3);
    }

    public InputStream read(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.read(x$1, x$2, x$3);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.fromPublisher(this.blobStoreDAO.delete(bucketName, blobId)).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public PassThroughBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

