/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.protocols.lib.netty.JMXEnabledOrderedMemoryAwareThreadPoolExecutorMBean;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class JMXEnabledOrderedMemoryAwareThreadPoolExecutor
extends OrderedMemoryAwareThreadPoolExecutor
implements JMXEnabledOrderedMemoryAwareThreadPoolExecutorMBean {
    private final String jmxPath;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final AtomicInteger totalTasks = new AtomicInteger(0);
    private MBeanServer mbeanServer;
    private String mbeanName;

    public JMXEnabledOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, String jmxPath, String name) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, 30L, TimeUnit.SECONDS, (ThreadFactory)NamedThreadFactory.withName((String)name));
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.startTime.set(System.currentTimeMillis());
    }

    protected void afterExecute(Runnable r, Throwable t) {
        long time = System.currentTimeMillis() - this.startTime.get();
        this.totalTime.addAndGet(time);
        this.totalTasks.incrementAndGet();
        super.afterExecute(r, t);
    }

    private void registerMBean() {
        if (this.jmxPath != null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.mbeanName = this.jmxPath + ",threadpool=" + ((NamedThreadFactory)this.getThreadFactory()).getName();
            try {
                this.mbeanServer.registerMBean(this, new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register mbean", e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.jmxPath != null) {
            try {
                this.mbeanServer.unregisterMBean(new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to unregister mbean", e);
            }
        }
    }

    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
        this.startTime.remove();
    }

    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    public synchronized int getTotalTasks() {
        return this.totalTasks.get();
    }

    public synchronized double getAverageTaskTime() {
        return this.totalTasks.get() == 0 ? 0.0 : (double)(this.totalTime.get() / (long)this.totalTasks.get());
    }

    public int getActiveThreads() {
        return this.getPoolSize();
    }

    public int getActiveTasks() {
        return this.getActiveCount();
    }

    public int getQueuedTasks() {
        return this.getQueue().size();
    }

    public int getMaximalThreads() {
        return this.getMaximumPoolSize();
    }
}

