/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.Literal;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedNioFile;
import org.jboss.netty.handler.stream.ChunkedStream;

public class ChannelImapResponseWriter
implements ImapResponseWriter {
    private final Channel channel;
    private final boolean zeroCopy;

    public ChannelImapResponseWriter(Channel channel) {
        this(channel, true);
    }

    public ChannelImapResponseWriter(Channel channel, boolean zeroCopy) {
        this.channel = channel;
        this.zeroCopy = zeroCopy;
    }

    public void write(byte[] buffer) throws IOException {
        if (this.channel.isConnected()) {
            this.channel.write((Object)ChannelBuffers.wrappedBuffer((byte[])buffer));
        }
    }

    public void write(Literal literal) throws IOException {
        if (this.channel.isConnected()) {
            InputStream in = literal.getInputStream();
            if (in instanceof FileInputStream && this.channel.getFactory() instanceof NioServerSocketChannelFactory) {
                FileChannel fc = ((FileInputStream)in).getChannel();
                ChannelPipeline cp = this.channel.getPipeline();
                if (this.zeroCopy && cp.get(SslHandler.class) == null && cp.get(ZlibEncoder.class) == null) {
                    this.channel.write((Object)new DefaultFileRegion(fc, fc.position(), literal.size()));
                } else {
                    this.channel.write((Object)new ChunkedNioFile(fc, 8192));
                }
            } else {
                this.channel.write((Object)new ChunkedStream(literal.getInputStream()));
            }
        }
    }
}

