/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class CachingGenerator
implements RuleMethodProcessor {
    private ParserClassNode classNode;
    private RuleMethod method;
    private InsnList instructions;
    private AbstractInsnNode current;
    private String cacheFieldName;

    CachingGenerator() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.hasCachedAnnotation();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        Preconditions.checkState(!ruleMethod.isSuperMethod());
        this.classNode = parserClassNode;
        this.method = ruleMethod;
        this.instructions = ruleMethod.instructions;
        this.current = this.instructions.getFirst();
        this.generateCacheHitReturn();
        this.generateStoreNewProxyMatcher();
        this.seekToReturnInstruction();
        this.generateArmProxyMatcher();
        this.generateStoreInCache();
    }

    private void generateCacheHitReturn() {
        this.generateGetFromCache();
        this.insert(new InsnNode(89));
        LabelNode labelNode = new LabelNode();
        this.insert(new JumpInsnNode(198, labelNode));
        this.insert(new InsnNode(176));
        this.insert(labelNode);
        this.insert(new InsnNode(87));
    }

    private void generateGetFromCache() {
        Type[] typeArray = Type.getArgumentTypes(this.method.desc);
        this.cacheFieldName = this.findUnusedCacheFieldName();
        String string = typeArray.length == 0 ? Types.RULE_DESC : "Ljava/util/HashMap;";
        this.classNode.fields.add(new FieldNode(2, this.cacheFieldName, string, null, null));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, string));
        if (typeArray.length == 0) {
            return;
        }
        this.insert(new InsnNode(89));
        LabelNode labelNode = new LabelNode();
        this.insert(new JumpInsnNode(199, labelNode));
        this.insert(new InsnNode(87));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new TypeInsnNode(187, "java/util/HashMap"));
        this.insert(new InsnNode(90));
        this.insert(new InsnNode(89));
        this.insert(new MethodInsnNode(183, "java/util/HashMap", "<init>", "()V", false));
        this.insert(new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, string));
        this.insert(labelNode);
        if (typeArray.length > 1 || typeArray[0].getSort() == 9) {
            String string2 = Type.getInternalName(Arguments.class);
            this.insert(new TypeInsnNode(187, string2));
            this.insert(new InsnNode(89));
            this.generatePushNewParameterObjectArray(typeArray);
            this.insert(new MethodInsnNode(183, string2, "<init>", "([Ljava/lang/Object;)V", false));
        } else {
            this.generatePushParameterAsObject(typeArray, 0);
        }
        this.insert(new InsnNode(89));
        this.insert(new VarInsnNode(58, this.method.maxLocals));
        this.insert(new MethodInsnNode(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false));
        this.insert(new TypeInsnNode(192, Types.RULE.getInternalName()));
    }

    private String findUnusedCacheFieldName() {
        String string = "cache$" + this.method.name;
        int n = 2;
        while (this.hasField(string)) {
            string = "cache$" + this.method.name + n++;
        }
        return string;
    }

    public boolean hasField(String string) {
        for (Object e : this.classNode.fields) {
            if (!string.equals(((FieldNode)e).name)) continue;
            return true;
        }
        return false;
    }

    private void generatePushNewParameterObjectArray(Type[] typeArray) {
        this.insert(new IntInsnNode(16, typeArray.length));
        this.insert(new TypeInsnNode(189, "java/lang/Object"));
        for (int i = 0; i < typeArray.length; ++i) {
            this.insert(new InsnNode(89));
            this.insert(new IntInsnNode(16, i));
            this.generatePushParameterAsObject(typeArray, i);
            this.insert(new InsnNode(83));
        }
    }

    private void generatePushParameterAsObject(Type[] typeArray, int n) {
        switch (typeArray[n++].getSort()) {
            case 1: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false));
                return;
            }
            case 2: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false));
                return;
            }
            case 3: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false));
                return;
            }
            case 4: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false));
                return;
            }
            case 5: {
                this.insert(new VarInsnNode(21, n));
                this.insert(new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false));
                return;
            }
            case 6: {
                this.insert(new VarInsnNode(23, n));
                this.insert(new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false));
                return;
            }
            case 7: {
                this.insert(new VarInsnNode(22, n));
                this.insert(new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false));
                return;
            }
            case 8: {
                this.insert(new VarInsnNode(24, n));
                this.insert(new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false));
                return;
            }
            case 9: 
            case 10: {
                this.insert(new VarInsnNode(25, n));
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void generateStoreNewProxyMatcher() {
        String string = Types.PROXY_MATCHER.getInternalName();
        this.insert(new TypeInsnNode(187, string));
        this.insert(new InsnNode(89));
        this.insert(new MethodInsnNode(183, string, "<init>", "()V", false));
        this.generateStoreInCache();
    }

    private void seekToReturnInstruction() {
        while (this.current.getOpcode() != 176) {
            this.current = this.current.getNext();
        }
    }

    private void generateArmProxyMatcher() {
        String string = Types.PROXY_MATCHER.getInternalName();
        this.insert(new InsnNode(90));
        this.insert(new TypeInsnNode(192, Types.MATCHER.getInternalName()));
        this.insert(new MethodInsnNode(182, string, "arm", '(' + Types.MATCHER_DESC + ")V", false));
    }

    private void generateStoreInCache() {
        Type[] typeArray = Type.getArgumentTypes(this.method.desc);
        this.insert(new InsnNode(89));
        if (typeArray.length == 0) {
            this.insert(new VarInsnNode(25, 0));
            this.insert(new InsnNode(95));
            this.insert(new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, Types.RULE_DESC));
            return;
        }
        this.insert(new VarInsnNode(25, this.method.maxLocals));
        this.insert(new InsnNode(95));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, "Ljava/util/HashMap;"));
        this.insert(new InsnNode(91));
        this.insert(new InsnNode(87));
        this.insert(new MethodInsnNode(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false));
        this.insert(new InsnNode(87));
    }

    private void insert(AbstractInsnNode abstractInsnNode) {
        this.instructions.insertBefore(this.current, abstractInsnNode);
    }

    public static class Arguments {
        private final Object[] params;

        public Arguments(Object[] objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.unroll(objectArray, arrayList);
            this.params = arrayList.toArray();
        }

        private void unroll(Object[] objectArray, List<Object> list) {
            block11: for (Object object : objectArray) {
                if (object != null && object.getClass().isArray()) {
                    switch (Type.getType(object.getClass().getComponentType()).getSort()) {
                        case 1: {
                            this.unroll(Utils.toObjectArray((boolean[])object), list);
                            continue block11;
                        }
                        case 3: {
                            this.unroll(Utils.toObjectArray((byte[])object), list);
                            continue block11;
                        }
                        case 2: {
                            this.unroll(Utils.toObjectArray((char[])object), list);
                            continue block11;
                        }
                        case 8: {
                            this.unroll(Utils.toObjectArray((double[])object), list);
                            continue block11;
                        }
                        case 6: {
                            this.unroll(Utils.toObjectArray((float[])object), list);
                            continue block11;
                        }
                        case 5: {
                            this.unroll(Utils.toObjectArray((int[])object), list);
                            continue block11;
                        }
                        case 7: {
                            this.unroll(Utils.toObjectArray((long[])object), list);
                            continue block11;
                        }
                        case 4: {
                            this.unroll(Utils.toObjectArray((short[])object), list);
                            continue block11;
                        }
                        case 9: 
                        case 10: {
                            this.unroll((Object[])object, list);
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                list.add(object);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Arguments)) {
                return false;
            }
            Arguments arguments = (Arguments)object;
            return Arrays.equals(this.params, arguments.params);
        }

        public int hashCode() {
            return this.params != null ? Arrays.hashCode(this.params) : 0;
        }
    }
}

