/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.nustaq.logging.FSTLogger;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectRegistry;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerialisationListener;
import org.nustaq.serialization.util.FSTUtil;

public class FSTObjectOutput
implements ObjectOutput {
    private static final FSTLogger LOGGER = FSTLogger.getLogger(FSTObjectOutput.class);
    public static Object NULL_PLACEHOLDER = new Object(){

        public String toString() {
            return "NULL_PLACEHOLDER";
        }
    };
    public static final byte SPECIAL_COMPATIBILITY_OBJECT_TAG = -19;
    public static final byte ONE_OF = -18;
    public static final byte BIG_BOOLEAN_FALSE = -17;
    public static final byte BIG_BOOLEAN_TRUE = -16;
    public static final byte BIG_LONG = -10;
    public static final byte BIG_INT = -9;
    public static final byte DIRECT_ARRAY_OBJECT = -8;
    public static final byte HANDLE = -7;
    public static final byte ENUM = -6;
    public static final byte ARRAY = -5;
    public static final byte STRING = -4;
    public static final byte TYPED = -3;
    public static final byte DIRECT_OBJECT = -2;
    public static final byte NULL = -1;
    public static final byte OBJECT = 0;
    protected FSTEncoder codec;
    protected FSTConfiguration conf;
    protected FSTObjectRegistry objects;
    protected int curDepth = 0;
    protected int writeExternalWriteAhead = 8000;
    protected FSTSerialisationListener listener;
    protected boolean dontShare;
    protected final FSTClazzInfo stringInfo;
    protected boolean isCrossPlatform;
    protected ThreadLocal<FSTClazzInfo.FSTFieldInfo[]> refsLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new FSTClazzInfo.FSTFieldInfo[20];
        }
    };
    FSTClazzInfo.FSTFieldInfo[] refs;
    protected static ByteArrayOutputStream empty = new ByteArrayOutputStream(0);
    protected boolean closed = false;
    protected int[] tmp = new int[]{0};

    public FSTObjectOutput(OutputStream out) {
        this(out, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectOutput(OutputStream out, FSTConfiguration conf) {
        this.conf = conf;
        this.setCodec(conf.createStreamEncoder());
        this.getCodec().setOutstream(out);
        this.isCrossPlatform = conf.isCrossPlatform();
        this.objects = (FSTObjectRegistry)conf.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(conf);
            this.objects.disabled = !conf.isShareReferences();
        } else {
            this.objects.clearForWrite(conf);
        }
        this.dontShare = this.objects.disabled;
        this.stringInfo = this.getClassInfoRegistry().getCLInfo(String.class, conf);
    }

    public FSTObjectOutput(FSTConfiguration conf) {
        this(null, conf);
        this.getCodec().setOutstream(null);
    }

    public FSTObjectOutput() {
        this(null, FSTConfiguration.getDefaultConfiguration());
        this.getCodec().setOutstream(null);
    }

    @Override
    public void flush() throws IOException {
        this.getCodec().flush();
        this.resetAndClearRefs();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        this.getCodec().close();
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects);
    }

    public int getWriteExternalWriteAhead() {
        return this.writeExternalWriteAhead;
    }

    public void setWriteExternalWriteAhead(int writeExternalWriteAhead) {
        this.writeExternalWriteAhead = writeExternalWriteAhead;
    }

    public void ensureFree(int bytes) throws IOException {
        this.getCodec().ensureFree(bytes);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.writeObject(obj, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.getCodec().writeFByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getCodec().writePrimitiveArray(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getCodec().writePrimitiveArray(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.getCodec().writeFByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.getCodec().writeFByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.getCodec().writeFShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.getCodec().writeFChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.getCodec().writeFInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.getCodec().writeFLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.getCodec().writeFFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.getCodec().writeFDouble(v);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        byte[] bytes = s2.getBytes();
        this.getCodec().writePrimitiveArray(bytes, 0, bytes.length);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        char[] chars = s2.toCharArray();
        this.getCodec().writePrimitiveArray(chars, 0, chars.length);
    }

    @Override
    public void writeUTF(String s2) throws IOException {
        this.getCodec().writeStringUTF(s2);
    }

    public void writeObject(Object obj, Class ... possibles) throws IOException {
        if (this.isCrossPlatform) {
            this.writeObjectInternal(obj, null, new Class[0]);
            return;
        }
        if (possibles != null && possibles.length > 1) {
            for (int i = 0; i < possibles.length; ++i) {
                Class possible = possibles[i];
                this.getCodec().registerClass(possible);
            }
        }
        this.writeObjectInternal(obj, null, possibles);
    }

    protected FSTClazzInfo.FSTFieldInfo getCachedFI(Class ... possibles) {
        if (this.refs == null) {
            this.refs = this.refsLocal.get();
        }
        if (this.curDepth >= this.refs.length) {
            return new FSTClazzInfo.FSTFieldInfo(possibles, null, true);
        }
        FSTClazzInfo.FSTFieldInfo inf = this.refs[this.curDepth];
        if (inf == null) {
            this.refs[this.curDepth] = inf = new FSTClazzInfo.FSTFieldInfo(possibles, null, true);
            return inf;
        }
        inf.setPossibleClasses(possibles);
        return inf;
    }

    public FSTClazzInfo writeObjectInternal(Object obj, FSTClazzInfo ci, Class ... possibles) throws IOException {
        FSTClazzInfo.FSTFieldInfo info = this.getCachedFI(possibles);
        ++this.curDepth;
        FSTClazzInfo fstClazzInfo = this.writeObjectWithContext(info, obj, ci);
        --this.curDepth;
        if (fstClazzInfo == null) {
            return null;
        }
        return fstClazzInfo.useCompatibleMode() ? null : fstClazzInfo;
    }

    public FSTSerialisationListener getListener() {
        return this.listener;
    }

    public void setListener(FSTSerialisationListener listener) {
        this.listener = listener;
    }

    protected void objectWillBeWritten(Object obj, int streamPosition) {
        if (this.listener != null) {
            this.listener.objectWillBeWritten(obj, streamPosition);
        }
    }

    protected void objectHasBeenWritten(Object obj, int oldStreamPosition, int streamPosition) {
        if (this.listener != null) {
            this.listener.objectHasBeenWritten(obj, oldStreamPosition, streamPosition);
        }
    }

    protected FSTClazzInfo writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        return this.writeObjectWithContext(referencee, toWrite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FSTClazzInfo writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo ci) throws IOException {
        int startPosition = 0;
        try {
            if (toWrite == null) {
                this.getCodec().writeTag((byte)-1, null, 0L, toWrite, this);
                FSTClazzInfo fSTClazzInfo = null;
                return fSTClazzInfo;
            }
            startPosition = this.getCodec().getWritten();
            this.objectWillBeWritten(toWrite, startPosition);
            Class<?> clazz = toWrite.getClass();
            if (clazz == String.class) {
                String[] oneOf = referencee.getOneOf();
                if (oneOf != null) {
                    for (int i = 0; i < oneOf.length; ++i) {
                        String s2 = oneOf[i];
                        if (!s2.equals(toWrite)) continue;
                        this.getCodec().writeTag((byte)-18, oneOf, i, toWrite, this);
                        this.getCodec().writeFByte(i);
                        FSTClazzInfo fSTClazzInfo = null;
                        return fSTClazzInfo;
                    }
                }
                if (!this.dontShare && this.writeHandleIfApplicable(toWrite, this.stringInfo)) {
                    FSTClazzInfo i = this.stringInfo;
                    return i;
                }
                this.getCodec().writeTag((byte)-4, toWrite, 0L, toWrite, this);
                this.getCodec().writeStringUTF((String)toWrite);
                FSTClazzInfo i = null;
                return i;
            }
            if (clazz == Integer.class) {
                this.getCodec().writeTag((byte)-9, null, 0L, toWrite, this);
                this.getCodec().writeFInt((Integer)toWrite);
                FSTClazzInfo oneOf = null;
                return oneOf;
            }
            if (clazz == Long.class) {
                this.getCodec().writeTag((byte)-10, null, 0L, toWrite, this);
                this.getCodec().writeFLong((Long)toWrite);
                FSTClazzInfo oneOf = null;
                return oneOf;
            }
            if (clazz == Boolean.class) {
                this.getCodec().writeTag((Boolean)toWrite != false ? (byte)-16 : -17, null, 0L, toWrite, this);
                FSTClazzInfo oneOf = null;
                return oneOf;
            }
            if (referencee.getType() != null && referencee.getType().isEnum() || toWrite instanceof Enum) {
                FSTClazzInfo oneOf = this.writeEnum(referencee, toWrite);
                return oneOf;
            }
            FSTClazzInfo serializationInfo = ci == null ? this.getFstClazzInfo(referencee, clazz) : ci;
            FSTObjectSerializer ser = serializationInfo.getSer();
            if (!(this.dontShare || referencee.isFlat() || serializationInfo.isFlat() || ser != null && ser.alwaysCopy() || !this.writeHandleIfApplicable(toWrite, serializationInfo))) {
                FSTClazzInfo s2 = serializationInfo;
                return s2;
            }
            if (clazz.isArray()) {
                if (this.getCodec().writeTag((byte)-5, toWrite, 0L, toWrite, this)) {
                    FSTClazzInfo s2 = serializationInfo;
                    return s2;
                }
                this.writeArray(referencee, toWrite);
                this.getCodec().writeArrayEnd();
            } else {
                if (ser == null) {
                    Object replaced;
                    FSTClazzInfo originalInfo = serializationInfo;
                    if (serializationInfo.getWriteReplaceMethod() != null) {
                        replaced = null;
                        try {
                            replaced = serializationInfo.getWriteReplaceMethod().invoke(toWrite, new Object[0]);
                        }
                        catch (Exception e) {
                            FSTUtil.rethrow(e);
                        }
                        if (replaced != toWrite) {
                            toWrite = replaced;
                            serializationInfo = this.getClassInfoRegistry().getCLInfo(toWrite.getClass(), this.conf);
                        }
                    }
                    if (serializationInfo.useCompatibleMode() && !serializationInfo.isExternalizable()) {
                        this.writeObjectCompatible(referencee, toWrite, serializationInfo);
                        replaced = originalInfo;
                        return replaced;
                    }
                    if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                        ser = serializationInfo.getSer();
                        if (ser == null) {
                            this.defaultWriteObject(toWrite, serializationInfo);
                            if (serializationInfo.isExternalizable()) {
                                this.getCodec().externalEnd(serializationInfo);
                            }
                        } else {
                            int pos = this.getCodec().getWritten();
                            ser.writeObject(this, toWrite, serializationInfo, referencee, pos);
                            this.getCodec().externalEnd(serializationInfo);
                        }
                    }
                    FSTClazzInfo fSTClazzInfo = originalInfo;
                    return fSTClazzInfo;
                }
                if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                    int pos = this.getCodec().getWritten();
                    ser.writeObject(this, toWrite, serializationInfo, referencee, pos);
                    this.getCodec().externalEnd(serializationInfo);
                }
            }
            FSTClazzInfo fSTClazzInfo = serializationInfo;
            return fSTClazzInfo;
        }
        finally {
            this.objectHasBeenWritten(toWrite, startPosition, this.getCodec().getWritten());
        }
    }

    protected FSTClazzInfo writeEnum(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        if (!this.getCodec().writeTag((byte)-6, toWrite, 0L, toWrite, this)) {
            Class<?> c;
            boolean isEnumClass = toWrite.getClass().isEnum();
            if (!isEnumClass) {
                c = toWrite.getClass();
                c = toWrite.getClass().getSuperclass();
                if (c == null) {
                    throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                }
            } else {
                FSTClazzInfo fstClazzInfo = this.getFstClazzInfo(referencee, toWrite.getClass());
                this.getCodec().writeClass(fstClazzInfo);
                this.getCodec().writeFInt(((Enum)toWrite).ordinal());
                return fstClazzInfo;
            }
            this.getCodec().writeClass(c);
            this.getCodec().writeFInt(((Enum)toWrite).ordinal());
        }
        return null;
    }

    protected boolean writeHandleIfApplicable(Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        int writePos = this.getCodec().getWritten();
        int handle = this.objects.registerObjectForWrite(toWrite, writePos, serializationInfo, this.tmp);
        if (handle >= 0) {
            boolean isIdentical;
            boolean bl = isIdentical = this.tmp[0] == 0;
            if (isIdentical) {
                if (!this.getCodec().writeTag((byte)-7, null, handle, toWrite, this)) {
                    this.getCodec().writeFInt(handle);
                }
                return true;
            }
        }
        return false;
    }

    protected FSTClazzInfo getFstClazzInfo(FSTClazzInfo.FSTFieldInfo referencee, Class clazz) {
        FSTClazzInfo serializationInfo = null;
        FSTClazzInfo lastInfo = referencee.lastInfo;
        if (lastInfo != null && lastInfo.getClazz() == clazz && lastInfo.conf == this.conf) {
            serializationInfo = lastInfo;
        } else {
            referencee.lastInfo = serializationInfo = this.getClassInfoRegistry().getCLInfo(clazz, this.conf);
        }
        return serializationInfo;
    }

    public void defaultWriteObject(Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        if (serializationInfo.isExternalizable()) {
            this.getCodec().ensureFree(this.writeExternalWriteAhead);
            ((Externalizable)toWrite).writeExternal(this);
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = serializationInfo.getFieldInfo();
            this.writeObjectFields(toWrite, serializationInfo, fieldInfo, 0, 0);
        }
    }

    protected void writeObjectCompatible(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        this.writeObjectHeader(serializationInfo, referencee, toWrite);
        Class cl = serializationInfo.getClazz();
        this.writeObjectCompatibleRecursive(referencee, toWrite, serializationInfo, cl);
    }

    protected void writeObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo serializationInfo, Class cl) throws IOException {
        FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = serializationInfo.getCompInfo().get(cl);
        if (!Serializable.class.isAssignableFrom(cl)) {
            return;
        }
        this.writeObjectCompatibleRecursive(referencee, toWrite, serializationInfo, cl.getSuperclass());
        if (fstCompatibilityInfo != null && fstCompatibilityInfo.getWriteMethod() != null) {
            try {
                this.writeByte(55);
                fstCompatibilityInfo.getWriteMethod().invoke(toWrite, this.getObjectOutputStream(cl, serializationInfo, referencee, toWrite));
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() != null) {
                    FSTUtil.rethrow(((InvocationTargetException)e).getTargetException());
                }
                FSTUtil.rethrow(e);
            }
        } else if (fstCompatibilityInfo != null) {
            this.writeByte(66);
            this.writeObjectFields(toWrite, serializationInfo, fstCompatibilityInfo.getFieldArray(), 0, 0);
        }
    }

    protected void writeObjectFields(Object toWrite, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, int startIndex, int version) throws IOException {
        try {
            int booleanMask = 0;
            int boolcount = 0;
            int length = fieldInfo.length;
            int j = startIndex;
            if (!this.getCodec().isWritingAttributes()) {
                while (true) {
                    if (j == length || fieldInfo[j].getVersion() != version) {
                        if (boolcount <= 0) break;
                        this.getCodec().writeFByte(booleanMask << 8 - boolcount);
                        break;
                    }
                    FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[j];
                    if (subInfo.getIntegralType() != 1) {
                        if (boolcount <= 0) break;
                        this.getCodec().writeFByte(booleanMask << 8 - boolcount);
                        break;
                    }
                    if (boolcount == 8) {
                        this.getCodec().writeFByte(booleanMask << 8 - boolcount);
                        boolcount = 0;
                        booleanMask = 0;
                    }
                    boolean booleanValue = subInfo.getBooleanValue(toWrite);
                    booleanMask <<= 1;
                    booleanMask |= booleanValue ? 1 : 0;
                    ++boolcount;
                    ++j;
                }
            }
            for (int i = j; i < length; ++i) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.getVersion() != version) {
                    this.getCodec().writeVersionTag(subInfo.getVersion());
                    this.writeObjectFields(toWrite, serializationInfo, fieldInfo, i, subInfo.getVersion());
                    return;
                }
                if (this.getCodec().writeAttributeName(subInfo, toWrite)) continue;
                if (subInfo.isPrimitive()) {
                    int integralType = subInfo.getIntegralType();
                    switch (integralType) {
                        case 1: {
                            this.getCodec().writeFByte(subInfo.getBooleanValue(toWrite) ? 1 : 0);
                            break;
                        }
                        case 2: {
                            this.getCodec().writeFByte(subInfo.getByteValue(toWrite));
                            break;
                        }
                        case 3: {
                            this.getCodec().writeFChar((char)subInfo.getCharValue(toWrite));
                            break;
                        }
                        case 4: {
                            this.getCodec().writeFShort((short)subInfo.getShortValue(toWrite));
                            break;
                        }
                        case 5: {
                            this.getCodec().writeFInt(subInfo.getIntValue(toWrite));
                            break;
                        }
                        case 6: {
                            this.getCodec().writeFLong(subInfo.getLongValue(toWrite));
                            break;
                        }
                        case 7: {
                            this.getCodec().writeFFloat(subInfo.getFloatValue(toWrite));
                            break;
                        }
                        case 8: {
                            this.getCodec().writeFDouble(subInfo.getDoubleValue(toWrite));
                        }
                    }
                    continue;
                }
                if (subInfo.isConditional()) {
                    int conditional = this.getCodec().getWritten();
                    this.getCodec().skip(4);
                    Object subObject = subInfo.getObjectValue(toWrite);
                    if (subObject == null) {
                        this.getCodec().writeTag((byte)-1, null, 0L, toWrite, this);
                    } else {
                        this.writeObjectWithContext(subInfo, subObject);
                    }
                    int v = this.getCodec().getWritten();
                    this.getCodec().writeInt32At(conditional, v);
                    continue;
                }
                Object subObject = subInfo.getObjectValue(toWrite);
                if (subObject == null) {
                    this.getCodec().writeTag((byte)-1, null, 0L, toWrite, this);
                    continue;
                }
                this.writeObjectWithContext(subInfo, subObject);
            }
            this.getCodec().writeVersionTag(0);
            this.getCodec().writeFieldsEnd(serializationInfo);
        }
        catch (IllegalAccessException ex) {
            FSTUtil.rethrow(ex);
        }
    }

    protected void writeCompatibleObjectFields(Object toWrite, Map fields, FSTClazzInfo.FSTFieldInfo[] fieldInfo) throws IOException {
        int booleanMask = 0;
        int boolcount = 0;
        for (int i = 0; i < fieldInfo.length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                boolean isarr = subInfo.isArray();
                Class subInfType = subInfo.getType();
                if ((subInfType != Boolean.TYPE || isarr) && boolcount > 0) {
                    this.getCodec().writeFByte(booleanMask << 8 - boolcount);
                    boolcount = 0;
                    booleanMask = 0;
                }
                if (subInfo.isIntegral() && !isarr) {
                    if (subInfType == Boolean.TYPE) {
                        if (boolcount == 8) {
                            this.getCodec().writeFByte(booleanMask << 8 - boolcount);
                            boolcount = 0;
                            booleanMask = 0;
                        }
                        boolean booleanValue = (Boolean)fields.get(subInfo.getName());
                        booleanMask <<= 1;
                        booleanMask |= booleanValue ? 1 : 0;
                        ++boolcount;
                        continue;
                    }
                    if (subInfType == Integer.TYPE) {
                        this.getCodec().writeFInt(((Number)fields.get(subInfo.getName())).intValue());
                        continue;
                    }
                    if (subInfType == Long.TYPE) {
                        this.getCodec().writeFLong(((Number)fields.get(subInfo.getName())).longValue());
                        continue;
                    }
                    if (subInfType == Byte.TYPE) {
                        this.getCodec().writeFByte(((Number)fields.get(subInfo.getName())).byteValue());
                        continue;
                    }
                    if (subInfType == Character.TYPE) {
                        this.getCodec().writeFChar((char)((Number)fields.get(subInfo.getName())).intValue());
                        continue;
                    }
                    if (subInfType == Short.TYPE) {
                        this.getCodec().writeFShort(((Number)fields.get(subInfo.getName())).shortValue());
                        continue;
                    }
                    if (subInfType == Float.TYPE) {
                        this.getCodec().writeFFloat(((Number)fields.get(subInfo.getName())).floatValue());
                        continue;
                    }
                    if (subInfType != Double.TYPE) continue;
                    this.getCodec().writeFDouble(((Number)fields.get(subInfo.getName())).doubleValue());
                    continue;
                }
                Object subObject = fields.get(subInfo.getName());
                this.writeObjectWithContext(subInfo, subObject);
                continue;
            }
            catch (Exception ex) {
                FSTUtil.rethrow(ex);
            }
        }
        if (boolcount > 0) {
            this.getCodec().writeFByte(booleanMask << 8 - boolcount);
        }
    }

    protected boolean writeObjectHeader(FSTClazzInfo clsInfo, FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        if (toWrite.getClass() == referencee.getType() && !clsInfo.useCompatibleMode()) {
            return this.getCodec().writeTag((byte)-3, clsInfo, 0L, toWrite, this);
        }
        Class[] possibleClasses = referencee.getPossibleClasses();
        if (possibleClasses == null) {
            if (!this.getCodec().writeTag((byte)0, clsInfo, 0L, toWrite, this)) {
                this.getCodec().writeClass(clsInfo);
                return false;
            }
            return true;
        }
        int length = possibleClasses.length;
        for (int j = 0; j < length; ++j) {
            Class possibleClass = possibleClasses[j];
            if (possibleClass != toWrite.getClass()) continue;
            this.getCodec().writeFByte(j + 1);
            return false;
        }
        if (!this.getCodec().writeTag((byte)0, clsInfo, 0L, toWrite, this)) {
            this.getCodec().writeClass(clsInfo);
            return false;
        }
        return true;
    }

    protected void writeArray(FSTClazzInfo.FSTFieldInfo referencee, Object array) throws IOException {
        if (array == null) {
            this.getCodec().writeClass(Object.class);
            this.getCodec().writeFInt(-1);
            return;
        }
        int len = Array.getLength(array);
        Class<?> componentType = array.getClass().getComponentType();
        this.getCodec().writeClass(array.getClass());
        this.getCodec().writeFInt(len);
        if (!componentType.isArray()) {
            if (this.getCodec().isPrimitiveArray(array, componentType)) {
                this.getCodec().writePrimitiveArray(array, 0, len);
            } else {
                Object[] arr = (Object[])array;
                Class<?> lastClz = null;
                FSTClazzInfo lastInfo = null;
                for (int i = 0; i < len; ++i) {
                    Object toWrite = arr[i];
                    if (toWrite != null) {
                        lastInfo = this.writeObjectWithContext(referencee, toWrite, lastClz == toWrite.getClass() ? lastInfo : null);
                        lastClz = toWrite.getClass();
                        continue;
                    }
                    this.writeObjectWithContext(referencee, toWrite, null);
                }
            }
        } else {
            Object[] arr = (Object[])array;
            FSTClazzInfo.FSTFieldInfo ref1 = new FSTClazzInfo.FSTFieldInfo(referencee.getPossibleClasses(), null, this.conf.getCLInfoRegistry().isIgnoreAnnotations());
            for (int i = 0; i < len; ++i) {
                Object subArr = arr[i];
                boolean needsWrite = true;
                if (this.getCodec().isTagMultiDimSubArrays()) {
                    if (subArr == null) {
                        needsWrite = !this.getCodec().writeTag((byte)-1, null, 0L, null, this);
                    } else {
                        boolean bl = needsWrite = !this.getCodec().writeTag((byte)-5, subArr, 0L, subArr, this);
                    }
                }
                if (!needsWrite) continue;
                this.writeArray(ref1, subArr);
                this.getCodec().writeArrayEnd();
            }
        }
    }

    public void writeStringUTF(String str) throws IOException {
        this.getCodec().writeStringUTF(str);
    }

    protected void resetAndClearRefs() {
        this.getCodec().reset(null);
        this.objects.clearForWrite(this.conf);
    }

    public void resetForReUse(OutputStream out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.getCodec().reset(null);
        if (out != null) {
            this.getCodec().setOutstream(out);
        }
        this.objects.clearForWrite(this.conf);
    }

    public void resetForReUse() {
        this.resetForReUse((byte[])null);
    }

    public void resetForReUse(byte[] out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.getCodec().reset(out);
        this.objects.clearForWrite(this.conf);
    }

    public FSTClazzInfoRegistry getClassInfoRegistry() {
        return this.conf.getCLInfoRegistry();
    }

    public ObjectOutputStream getObjectOutputStream(final Class cl, final FSTClazzInfo clinfo, final FSTClazzInfo.FSTFieldInfo referencee, final Object toWrite) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(){
            ObjectOutputStream.PutField pf;
            HashMap<String, Object> fields = new HashMap();

            @Override
            public void useProtocolVersion(int version) throws IOException {
            }

            @Override
            protected void writeObjectOverride(Object obj) throws IOException {
                FSTObjectOutput.this.getCodec().writeFByte(-19);
                FSTObjectOutput.this.writeObjectInternal(obj, null, referencee.getPossibleClasses());
            }

            @Override
            public void writeUnshared(Object obj) throws IOException {
                this.writeObjectOverride(obj);
            }

            @Override
            public void defaultWriteObject() throws IOException {
                this.writeByte(99);
                FSTClazzInfo newInfo = clinfo;
                Object replObj = toWrite;
                if (newInfo.getWriteReplaceMethod() != null) {
                    LOGGER.log(FSTLogger.Level.WARN, "WRITE REPLACE NOT FULLY SUPPORTED", null);
                    try {
                        Object replaced = newInfo.getWriteReplaceMethod().invoke(replObj, new Object[0]);
                        if (replaced != null && replaced != toWrite) {
                            replObj = replaced;
                            newInfo = FSTObjectOutput.this.getClassInfoRegistry().getCLInfo(replObj.getClass(), FSTObjectOutput.this.conf);
                        }
                    }
                    catch (Exception e) {
                        FSTUtil.rethrow(e);
                    }
                }
                FSTObjectOutput.this.writeObjectFields(replObj, newInfo, newInfo.getCompInfo().get(cl).getFieldArray(), 0, 0);
            }

            @Override
            public ObjectOutputStream.PutField putFields() throws IOException {
                if (this.pf == null) {
                    this.pf = new ObjectOutputStream.PutField(){

                        @Override
                        public void put(String name, boolean val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, byte val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, char val) {
                            fields.put(name, Character.valueOf(val));
                        }

                        @Override
                        public void put(String name, short val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, int val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, long val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, float val) {
                            fields.put(name, Float.valueOf(val));
                        }

                        @Override
                        public void put(String name, double val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, Object val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void write(ObjectOutput out) throws IOException {
                            throw new IOException("cannot act compatible, use a custom serializer for this class");
                        }
                    };
                }
                return this.pf;
            }

            @Override
            public void writeFields() throws IOException {
                this.writeByte(77);
                FSTObjectOutput.this.writeObjectInternal(this.fields, null, HashMap.class);
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("cannot act compatible, use a custom serializer for this class");
            }

            @Override
            public void write(int val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFByte(val);
            }

            @Override
            public void write(byte[] buf) throws IOException {
                FSTObjectOutput.this.write(buf);
            }

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                FSTObjectOutput.this.write(buf, off, len);
            }

            @Override
            public void flush() throws IOException {
                FSTObjectOutput.this.flush();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void writeBoolean(boolean val) throws IOException {
                FSTObjectOutput.this.writeBoolean(val);
            }

            @Override
            public void writeByte(int val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFByte(val);
            }

            @Override
            public void writeShort(int val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFShort((short)val);
            }

            @Override
            public void writeChar(int val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFChar((char)val);
            }

            @Override
            public void writeInt(int val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFInt(val);
            }

            @Override
            public void writeLong(long val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFLong(val);
            }

            @Override
            public void writeFloat(float val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFFloat(val);
            }

            @Override
            public void writeDouble(double val) throws IOException {
                FSTObjectOutput.this.getCodec().writeFDouble(val);
            }

            @Override
            public void writeBytes(String str) throws IOException {
                FSTObjectOutput.this.writeBytes(str);
            }

            @Override
            public void writeChars(String str) throws IOException {
                FSTObjectOutput.this.writeChars(str);
            }

            @Override
            public void writeUTF(String str) throws IOException {
                FSTObjectOutput.this.getCodec().writeStringUTF(str);
            }
        };
        return out;
    }

    public FSTObjectRegistry getObjectMap() {
        return this.objects;
    }

    public byte[] getBuffer() {
        return this.getCodec().getBuffer();
    }

    public byte[] getCopyOfWrittenBuffer() {
        if (!this.getCodec().isByteArrayBased()) {
            return this.getBuffer();
        }
        byte[] res = new byte[this.getCodec().getWritten()];
        byte[] buffer = this.getBuffer();
        System.arraycopy(buffer, 0, res, 0, this.getCodec().getWritten());
        return res;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public int getWritten() {
        return this.getCodec().getWritten();
    }

    public void writeClassTag(Class aClass) {
        this.getCodec().writeClass(aClass);
    }

    public FSTEncoder getCodec() {
        return this.codec;
    }

    protected void setCodec(FSTEncoder codec) {
        this.codec = codec;
    }
}

