/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.expression;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;

public interface ExpressionTree {
    public boolean satisfy(Object var1);

    public Filter toFilter();

    public static class IdColumnMatch
    implements ExpressionTree {
        private Set<IDeviceID> satisfiedDeviceIds;

        public IdColumnMatch(List<IDeviceID> satisfiedDeviceIdList) {
            this.satisfiedDeviceIds = satisfiedDeviceIdList == null ? null : new HashSet<IDeviceID>(satisfiedDeviceIdList);
        }

        @Override
        public boolean satisfy(Object value) {
            return this.satisfiedDeviceIds == null || this.satisfiedDeviceIds.isEmpty() || this.satisfiedDeviceIds.contains(value);
        }

        @Override
        public Filter toFilter() {
            return null;
        }
    }

    public static class TimeBetweenAnd
    implements ExpressionTree {
        private long startTime;
        private long endTime;

        public TimeBetweenAnd(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        @Override
        public boolean satisfy(Object value) {
            long v = (Long)value;
            return v >= this.startTime && v <= this.endTime;
        }

        @Override
        public Filter toFilter() {
            return TimeFilterApi.between(this.startTime, this.endTime);
        }
    }
}

