/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.leaf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TimeSeriesOperand
extends LeafOperand {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeSeriesOperand.class);
    private final PartialPath path;
    private final TSDataType type;

    public TimeSeriesOperand(PartialPath path) {
        this.path = path;
        this.type = null;
    }

    public TimeSeriesOperand(PartialPath path, TSDataType dataType) {
        this.path = path;
        this.type = dataType;
    }

    public TimeSeriesOperand(ByteBuffer byteBuffer) {
        this.path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        boolean hasType = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.type = hasType ? TSDataType.deserializeFrom((ByteBuffer)byteBuffer) : null;
    }

    public static TimeSeriesOperand constructColumnHeaderExpression(String columnName, TSDataType dataType) {
        return new TimeSeriesOperand(new PartialPath(columnName, false), dataType);
    }

    public PartialPath getPath() {
        return this.path;
    }

    public TSDataType getOperandType() {
        return this.type != null ? this.type : this.path.getSeriesType();
    }

    public TSDataType getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTimeSeriesOperand(this, context);
    }

    @Override
    public boolean isConstantOperandInternal() {
        return false;
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        String digest = this.getExpressionString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.path.isMeasurementAliasExists() ? this.path.getFullPathWithAlias() : this.path.getFullPath();
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.TIMESERIES;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.path.serialize(byteBuffer);
        if (this.type == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            this.type.serializeTo(byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        this.path.serialize((OutputStream)stream);
        if (this.type == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.type.serializeTo(stream);
        }
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfPartialPath(this.path);
    }
}

