/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CreateSessionRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=459");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=461");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=460");
    private final RequestHeader requestHeader;
    private final ApplicationDescription clientDescription;
    private final String serverUri;
    private final String endpointUrl;
    private final String sessionName;
    private final ByteString clientNonce;
    private final ByteString clientCertificate;
    private final Double requestedSessionTimeout;
    private final UInteger maxResponseMessageSize;

    public CreateSessionRequest(RequestHeader requestHeader, ApplicationDescription clientDescription, String serverUri, String endpointUrl, String sessionName, ByteString clientNonce, ByteString clientCertificate, Double requestedSessionTimeout, UInteger maxResponseMessageSize) {
        this.requestHeader = requestHeader;
        this.clientDescription = clientDescription;
        this.serverUri = serverUri;
        this.endpointUrl = endpointUrl;
        this.sessionName = sessionName;
        this.clientNonce = clientNonce;
        this.clientCertificate = clientCertificate;
        this.requestedSessionTimeout = requestedSessionTimeout;
        this.maxResponseMessageSize = maxResponseMessageSize;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ApplicationDescription getClientDescription() {
        return this.clientDescription;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public ByteString getClientNonce() {
        return this.clientNonce;
    }

    public ByteString getClientCertificate() {
        return this.clientCertificate;
    }

    public Double getRequestedSessionTimeout() {
        return this.requestedSessionTimeout;
    }

    public UInteger getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    protected CreateSessionRequest(CreateSessionRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((CreateSessionRequestBuilder)b).requestHeader;
        this.clientDescription = ((CreateSessionRequestBuilder)b).clientDescription;
        this.serverUri = ((CreateSessionRequestBuilder)b).serverUri;
        this.endpointUrl = ((CreateSessionRequestBuilder)b).endpointUrl;
        this.sessionName = ((CreateSessionRequestBuilder)b).sessionName;
        this.clientNonce = ((CreateSessionRequestBuilder)b).clientNonce;
        this.clientCertificate = ((CreateSessionRequestBuilder)b).clientCertificate;
        this.requestedSessionTimeout = ((CreateSessionRequestBuilder)b).requestedSessionTimeout;
        this.maxResponseMessageSize = ((CreateSessionRequestBuilder)b).maxResponseMessageSize;
    }

    public static CreateSessionRequestBuilder<?, ?> builder() {
        return new CreateSessionRequestBuilderImpl();
    }

    public CreateSessionRequestBuilder<?, ?> toBuilder() {
        return new CreateSessionRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$requestedSessionTimeout = this.getRequestedSessionTimeout();
        Double other$requestedSessionTimeout = other.getRequestedSessionTimeout();
        if (this$requestedSessionTimeout == null ? other$requestedSessionTimeout != null : !((Object)this$requestedSessionTimeout).equals(other$requestedSessionTimeout)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        ApplicationDescription this$clientDescription = this.getClientDescription();
        ApplicationDescription other$clientDescription = other.getClientDescription();
        if (this$clientDescription == null ? other$clientDescription != null : !((Object)this$clientDescription).equals(other$clientDescription)) {
            return false;
        }
        String this$serverUri = this.getServerUri();
        String other$serverUri = other.getServerUri();
        if (this$serverUri == null ? other$serverUri != null : !this$serverUri.equals(other$serverUri)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$sessionName = this.getSessionName();
        String other$sessionName = other.getSessionName();
        if (this$sessionName == null ? other$sessionName != null : !this$sessionName.equals(other$sessionName)) {
            return false;
        }
        ByteString this$clientNonce = this.getClientNonce();
        ByteString other$clientNonce = other.getClientNonce();
        if (this$clientNonce == null ? other$clientNonce != null : !((Object)this$clientNonce).equals(other$clientNonce)) {
            return false;
        }
        ByteString this$clientCertificate = this.getClientCertificate();
        ByteString other$clientCertificate = other.getClientCertificate();
        if (this$clientCertificate == null ? other$clientCertificate != null : !((Object)this$clientCertificate).equals(other$clientCertificate)) {
            return false;
        }
        UInteger this$maxResponseMessageSize = this.getMaxResponseMessageSize();
        UInteger other$maxResponseMessageSize = other.getMaxResponseMessageSize();
        return !(this$maxResponseMessageSize == null ? other$maxResponseMessageSize != null : !((Object)this$maxResponseMessageSize).equals(other$maxResponseMessageSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateSessionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $requestedSessionTimeout = this.getRequestedSessionTimeout();
        result = result * 59 + ($requestedSessionTimeout == null ? 43 : ((Object)$requestedSessionTimeout).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        ApplicationDescription $clientDescription = this.getClientDescription();
        result = result * 59 + ($clientDescription == null ? 43 : ((Object)$clientDescription).hashCode());
        String $serverUri = this.getServerUri();
        result = result * 59 + ($serverUri == null ? 43 : $serverUri.hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $sessionName = this.getSessionName();
        result = result * 59 + ($sessionName == null ? 43 : $sessionName.hashCode());
        ByteString $clientNonce = this.getClientNonce();
        result = result * 59 + ($clientNonce == null ? 43 : ((Object)$clientNonce).hashCode());
        ByteString $clientCertificate = this.getClientCertificate();
        result = result * 59 + ($clientCertificate == null ? 43 : ((Object)$clientCertificate).hashCode());
        UInteger $maxResponseMessageSize = this.getMaxResponseMessageSize();
        result = result * 59 + ($maxResponseMessageSize == null ? 43 : ((Object)$maxResponseMessageSize).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CreateSessionRequest(requestHeader=" + this.getRequestHeader() + ", clientDescription=" + this.getClientDescription() + ", serverUri=" + this.getServerUri() + ", endpointUrl=" + this.getEndpointUrl() + ", sessionName=" + this.getSessionName() + ", clientNonce=" + this.getClientNonce() + ", clientCertificate=" + this.getClientCertificate() + ", requestedSessionTimeout=" + this.getRequestedSessionTimeout() + ", maxResponseMessageSize=" + this.getMaxResponseMessageSize() + ")";
    }

    private static final class CreateSessionRequestBuilderImpl
    extends CreateSessionRequestBuilder<CreateSessionRequest, CreateSessionRequestBuilderImpl> {
        private CreateSessionRequestBuilderImpl() {
        }

        @Override
        protected CreateSessionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }
    }

    public static abstract class CreateSessionRequestBuilder<C extends CreateSessionRequest, B extends CreateSessionRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private ApplicationDescription clientDescription;
        private String serverUri;
        private String endpointUrl;
        private String sessionName;
        private ByteString clientNonce;
        private ByteString clientCertificate;
        private Double requestedSessionTimeout;
        private UInteger maxResponseMessageSize;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateSessionRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CreateSessionRequest instance, CreateSessionRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.clientDescription(instance.clientDescription);
            b.serverUri(instance.serverUri);
            b.endpointUrl(instance.endpointUrl);
            b.sessionName(instance.sessionName);
            b.clientNonce(instance.clientNonce);
            b.clientCertificate(instance.clientCertificate);
            b.requestedSessionTimeout(instance.requestedSessionTimeout);
            b.maxResponseMessageSize(instance.maxResponseMessageSize);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B clientDescription(ApplicationDescription clientDescription) {
            this.clientDescription = clientDescription;
            return (B)this.self();
        }

        public B serverUri(String serverUri) {
            this.serverUri = serverUri;
            return (B)this.self();
        }

        public B endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return (B)this.self();
        }

        public B sessionName(String sessionName) {
            this.sessionName = sessionName;
            return (B)this.self();
        }

        public B clientNonce(ByteString clientNonce) {
            this.clientNonce = clientNonce;
            return (B)this.self();
        }

        public B clientCertificate(ByteString clientCertificate) {
            this.clientCertificate = clientCertificate;
            return (B)this.self();
        }

        public B requestedSessionTimeout(Double requestedSessionTimeout) {
            this.requestedSessionTimeout = requestedSessionTimeout;
            return (B)this.self();
        }

        public B maxResponseMessageSize(UInteger maxResponseMessageSize) {
            this.maxResponseMessageSize = maxResponseMessageSize;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CreateSessionRequest.CreateSessionRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", clientDescription=" + this.clientDescription + ", serverUri=" + this.serverUri + ", endpointUrl=" + this.endpointUrl + ", sessionName=" + this.sessionName + ", clientNonce=" + this.clientNonce + ", clientCertificate=" + this.clientCertificate + ", requestedSessionTimeout=" + this.requestedSessionTimeout + ", maxResponseMessageSize=" + this.maxResponseMessageSize + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CreateSessionRequest> {
        @Override
        public Class<CreateSessionRequest> getType() {
            return CreateSessionRequest.class;
        }

        @Override
        public CreateSessionRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ApplicationDescription clientDescription = (ApplicationDescription)decoder.readStruct("ClientDescription", ApplicationDescription.TYPE_ID);
            String serverUri = decoder.readString("ServerUri");
            String endpointUrl = decoder.readString("EndpointUrl");
            String sessionName = decoder.readString("SessionName");
            ByteString clientNonce = decoder.readByteString("ClientNonce");
            ByteString clientCertificate = decoder.readByteString("ClientCertificate");
            Double requestedSessionTimeout = decoder.readDouble("RequestedSessionTimeout");
            UInteger maxResponseMessageSize = decoder.readUInt32("MaxResponseMessageSize");
            return new CreateSessionRequest(requestHeader, clientDescription, serverUri, endpointUrl, sessionName, clientNonce, clientCertificate, requestedSessionTimeout, maxResponseMessageSize);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CreateSessionRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("ClientDescription", (Object)value.getClientDescription(), ApplicationDescription.TYPE_ID);
            encoder.writeString("ServerUri", value.getServerUri());
            encoder.writeString("EndpointUrl", value.getEndpointUrl());
            encoder.writeString("SessionName", value.getSessionName());
            encoder.writeByteString("ClientNonce", value.getClientNonce());
            encoder.writeByteString("ClientCertificate", value.getClientCertificate());
            encoder.writeDouble("RequestedSessionTimeout", value.getRequestedSessionTimeout());
            encoder.writeUInt32("MaxResponseMessageSize", value.getMaxResponseMessageSize());
        }
    }
}

