/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPart;
import org.apache.ignite.internal.catalog.sql.QueryUtils;

class Option
extends QueryPart {
    private final String name;
    private final Object value;

    private Option(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static Option partitions(Integer partitions) {
        return new Option("PARTITIONS", partitions);
    }

    public static Option replicas(Integer replicas) {
        return new Option("REPLICAS", replicas);
    }

    public static Option quorumSize(Integer quorumSize) {
        return new Option("QUORUM_SIZE", quorumSize);
    }

    public static Option dataNodesAutoAdjustScaleUp(Integer adjust) {
        return new Option("DATA_NODES_AUTO_ADJUST_SCALE_UP", adjust);
    }

    public static Option dataNodesAutoAdjustScaleDown(Integer adjust) {
        return new Option("DATA_NODES_AUTO_ADJUST_SCALE_DOWN", adjust);
    }

    public static Option distributionAlgorithm(String distributionAlgorithm) {
        return new Option("DISTRIBUTION_ALGORITHM", distributionAlgorithm);
    }

    public static Option dataRegion(String dataRegion) {
        return new Option("DATAREGION", dataRegion);
    }

    public static Option storageProfiles(String storageProfiles) {
        return new Option("STORAGE_PROFILES", storageProfiles);
    }

    public static Option consistencyMode(String consistencyMode) {
        return new Option("CONSISTENCY_MODE", consistencyMode);
    }

    public static Option name(String name) {
        return new Option("NAME", name);
    }

    public static Option tableName(String tableName) {
        return new Option("TABLE_NAME", tableName);
    }

    public static Option schemaName(String tableName) {
        return new Option("SCHEMA_NAME", tableName);
    }

    public static Option zoneName(String zoneName) {
        return new Option("ZONE_NAME", zoneName);
    }

    public static Option indexId(int indexId) {
        return new Option("INDEX_ID", indexId);
    }

    public static Option filter(String filter) {
        return new Option("DATA_NODES_FILTER", filter);
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql(this.name).sql("=");
        boolean isStringValue = this.value instanceof String;
        if (isStringValue) {
            char quoteChar;
            String strValue = this.value.toString();
            if (!QueryUtils.isQuoted(strValue, quoteChar = '\'')) {
                ctx.sql(quoteChar).sql(strValue).sql(quoteChar);
            }
        } else {
            ctx.sql(this.value.toString());
        }
    }
}

