/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class CheckpointPages {
    private final Set<DirtyFullPageId> pageIds;
    private final CheckpointProgressImpl checkpointProgress;

    public CheckpointPages(Set<DirtyFullPageId> pageIds, CheckpointProgress checkpointProgress) {
        this.pageIds = pageIds;
        this.checkpointProgress = (CheckpointProgressImpl)checkpointProgress;
    }

    public boolean removeOnPageReplacement(DirtyFullPageId pageId) throws IgniteInternalCheckedException {
        try {
            IgniteUtils.getUninterruptibly(this.checkpointProgress.futureFor(CheckpointState.PAGES_SORTED));
        }
        catch (ExecutionException e) {
            throw new IgniteInternalCheckedException(e.getCause());
        }
        catch (CancellationException e) {
            throw new IgniteInternalCheckedException((Throwable)e);
        }
        return this.pageIds.remove(pageId);
    }

    public boolean removeOnCheckpoint(DirtyFullPageId pageId) {
        return this.pageIds.remove(pageId);
    }

    public boolean contains(DirtyFullPageId pageId) {
        return this.pageIds.contains(pageId);
    }

    public int size() {
        return this.pageIds.size();
    }

    public void blockFsyncOnPageReplacement(DirtyFullPageId pageId) {
        this.checkpointProgress.blockFsyncOnPageReplacement(pageId);
    }

    public void unblockFsyncOnPageReplacement(DirtyFullPageId pageId, @Nullable Throwable error) {
        this.checkpointProgress.unblockFsyncOnPageReplacement(pageId, error);
    }
}

