/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.sources;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.LongStream;
import org.apache.ignite.internal.metrics.DistributionMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class RaftMetricSource
implements MetricSource {
    private static final String SOURCE_NAME = "raft";
    private static final VarHandle ENABLED;
    private volatile boolean enabled;
    private final int stripeCount;
    private final int logStripeCount;
    private final Map<String, Metric> metrics;

    public RaftMetricSource(int stripeCount, int logStripeCount) {
        this.stripeCount = stripeCount;
        this.logStripeCount = logStripeCount;
        this.metrics = this.createMetrics();
    }

    public String name() {
        return SOURCE_NAME;
    }

    @Nullable
    public MetricSet enable() {
        if (ENABLED.compareAndSet(this, false, true)) {
            return new MetricSet(SOURCE_NAME, this.metrics);
        }
        return null;
    }

    private Map<String, Metric> createMetrics() {
        long[] bounds = new long[]{10L, 20L, 30L, 40L, 50L};
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("raft.fsmcaller.disruptor.Batch", (Metric)new DistributionMetric("raft.fsmcaller.disruptor.Batch", "The histogram of the batch size to handle in the state machine for partitions", bounds));
        metrics.put("raft.fsmcaller.disruptor.Stripes", (Metric)new DistributionMetric("raft.fsmcaller.disruptor.Stripes", "The histogram of distribution data by stripes in the state machine for partitions", LongStream.range(0L, this.stripeCount).toArray()));
        metrics.put("raft.nodeimpl.disruptor.Batch", (Metric)new DistributionMetric("raft.nodeimpl.disruptor.Batch", "The histogram of the batch size to handle node operations for partitions", bounds));
        metrics.put("raft.nodeimpl.disruptor.Stripes", (Metric)new DistributionMetric("raft.nodeimpl.disruptor.Stripes", "The histogram of distribution data by stripes for node operations for partitions", LongStream.range(0L, this.stripeCount).toArray()));
        metrics.put("raft.readonlyservice.disruptor.Batch", (Metric)new DistributionMetric("raft.readonlyservice.disruptor.Batch", "The histogram of the batch size to handle readonly operations for partitions", bounds));
        metrics.put("raft.readonlyservice.disruptor.Stripes", (Metric)new DistributionMetric("raft.readonlyservice.disruptor.Stripes", "The histogram of distribution data by stripes readonly operations for partitions", LongStream.range(0L, this.stripeCount).toArray()));
        metrics.put("raft.logmanager.disruptor.Batch", (Metric)new DistributionMetric("raft.logmanager.disruptor.Batch", "The histogram of the batch size to handle in the log for partitions", bounds));
        metrics.put("raft.logmanager.disruptor.Stripes", (Metric)new DistributionMetric("raft.logmanager.disruptor.Stripes", "The histogram of distribution data by stripes in the log for partitions", LongStream.range(0L, this.logStripeCount).toArray()));
        return metrics;
    }

    public DisruptorMetrics disruptorMetrics(String name) {
        return new DisruptorMetrics((DistributionMetric)this.metrics.get(name + ".Batch"), (DistributionMetric)this.metrics.get(name + ".Stripes"));
    }

    public void disable() {
        ENABLED.compareAndSet(this, false, true);
    }

    public boolean enabled() {
        return this.enabled;
    }

    static {
        try {
            ENABLED = MethodHandles.lookup().findVarHandle(RaftMetricSource.class, "enabled", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public class DisruptorMetrics {
        private final DistributionMetric batchSizeHistogramMetric;
        private final DistributionMetric stripeHistogramMetric;

        DisruptorMetrics(DistributionMetric averageBatchSizeMetric, DistributionMetric stripeHistogramMetric) {
            this.batchSizeHistogramMetric = averageBatchSizeMetric;
            this.stripeHistogramMetric = stripeHistogramMetric;
        }

        public boolean enabled() {
            return RaftMetricSource.this.enabled;
        }

        public void addBatchSize(long size) {
            this.batchSizeHistogramMetric.add(size);
        }

        public void hitToStripe(int stripe) {
            this.stripeHistogramMetric.add((long)stripe);
        }
    }
}

