/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.table.RecordBinaryViewImpl;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class ClientStreamerBatchSendRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteTables tables) {
        return ClientTableCommon.readTableAsync(in, tables).thenCompose(table -> {
            int partition = in.unpackInt();
            BitSet deleted = in.unpackBitSetNullable();
            return ClientStreamerBatchSendRequest.readTuples(in, table, deleted).thenCompose(tuples -> {
                RecordBinaryViewImpl recordView = (RecordBinaryViewImpl)table.recordView();
                return recordView.updateAll(partition, (Collection)tuples, deleted).thenAccept(unused -> out.packInt(table.schemaView().lastKnownSchemaVersion()));
            });
        });
    }

    private static CompletableFuture<List<Tuple>> readTuples(ClientMessageUnpacker unpacker, TableViewInternal table, @Nullable BitSet deleted) {
        return ClientTableCommon.readSchema(unpacker, table).thenApply(schema -> {
            int rowCnt = unpacker.unpackInt();
            ArrayList<Tuple> res = new ArrayList<Tuple>(rowCnt);
            for (int i = 0; i < rowCnt; ++i) {
                boolean keyOnly = deleted != null && deleted.get(i);
                res.add(ClientTableCommon.readTuple(unpacker, keyOnly, schema));
            }
            return res;
        });
    }
}

