/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb.snapshot;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.rocksdb.snapshot.ColumnFamilyRange;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.AbstractSlice;
import org.rocksdb.EnvOptions;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;
import org.rocksdb.SstFileWriter;

public class RocksSnapshotManager {
    private static final String TMP_SUFFIX = ".tmp";
    private final RocksDB db;
    private final Collection<ColumnFamilyRange> ranges;
    private final Executor executor;

    public RocksSnapshotManager(RocksDB db, Collection<ColumnFamilyRange> ranges, Executor executor) {
        assert (!ranges.isEmpty());
        this.db = db;
        this.ranges = List.copyOf(ranges);
        this.executor = executor;
    }

    public CompletableFuture<Void> createSnapshot(Path snapshotDir) {
        Path tmpPath = Paths.get(snapshotDir.toString() + TMP_SUFFIX, new String[0]);
        Snapshot snapshot = this.db.getSnapshot();
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            RocksSnapshotManager.createTmpSnapshotDir(tmpPath);
            CompletableFuture[] sstFutures = (CompletableFuture[])this.ranges.stream().map(cf -> this.createSstFileAsync((ColumnFamilyRange)cf, snapshot, tmpPath)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(sstFutures);
        }, this.executor).thenCompose(Function.identity())).whenCompleteAsync((ignored, e) -> {
            this.db.releaseSnapshot(snapshot);
            snapshot.close();
            if (e != null) {
                return;
            }
            IgniteUtils.deleteIfExists((Path)snapshotDir);
            try {
                IgniteUtils.atomicMoveFile((Path)tmpPath, (Path)snapshotDir, null);
            }
            catch (IOException ex) {
                throw new IgniteInternalException("Failed to rename: " + String.valueOf(tmpPath) + " to " + String.valueOf(snapshotDir), (Throwable)ex);
            }
        }, this.executor)).thenApply(v -> null);
    }

    private static void createTmpSnapshotDir(Path tmpDirPath) {
        IgniteUtils.deleteIfExists((Path)tmpDirPath);
        try {
            Files.createDirectories(tmpDirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IgniteInternalException("Failed to create directory: " + String.valueOf(tmpDirPath), (Throwable)e);
        }
    }

    private CompletableFuture<Void> createSstFileAsync(ColumnFamilyRange range, Snapshot snapshot, Path snapshotDir) {
        return CompletableFuture.runAsync(() -> this.createSstFile(range, snapshot, snapshotDir), this.executor);
    }

    private void createSstFile(ColumnFamilyRange range, Snapshot snapshot, Path snapshotDir) {
        try (EnvOptions envOptions = new EnvOptions();
             Options options = new Options().setEnv(this.db.getEnv());
             SstFileWriter sstFileWriter = new SstFileWriter(envOptions, options);
             RocksIterator it = RocksSnapshotManager.snapshotIterator(range, snapshot);){
            Path sstFile = snapshotDir.resolve(range.columnFamily().name());
            sstFileWriter.open(sstFile.toString());
            RocksUtils.forEach(it, (arg_0, arg_1) -> ((SstFileWriter)sstFileWriter).put(arg_0, arg_1));
            sstFileWriter.finish();
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Failed to write snapshot", (Throwable)e);
        }
    }

    private static RocksIterator snapshotIterator(ColumnFamilyRange range, Snapshot snapshot) {
        ReadOptions options = new ReadOptions().setSnapshot(snapshot);
        if (range.isFullRange()) {
            RocksIterator it = range.columnFamily().newIterator(options);
            it.seekToFirst();
            return it;
        }
        options.setIterateUpperBound((AbstractSlice)new Slice(range.upperBound()));
        RocksIterator it = range.columnFamily().newIterator(options);
        it.seek(range.lowerBound());
        return it;
    }

    public void restoreSnapshot(Path snapshotDir) {
        try (IngestExternalFileOptions ingestOptions = new IngestExternalFileOptions();){
            for (ColumnFamilyRange range : this.ranges) {
                Path snapshotPath = snapshotDir.resolve(range.columnFamily().name());
                if (!Files.exists(snapshotPath, new LinkOption[0])) {
                    throw new IgniteInternalException("Snapshot not found: " + String.valueOf(snapshotPath));
                }
                range.columnFamily().ingestExternalFile(List.of(snapshotPath.toString()), ingestOptions);
            }
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Fail to ingest sst file at path: " + String.valueOf(snapshotDir), (Throwable)e);
        }
    }
}

