/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.IntersectionImpl;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectIntersectionTest {
    private static final int PREBYTES = 24;

    @Test
    public void checkExactIntersectionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)usk1);
        inter.intersect((Sketch)usk2);
        long[] cache = inter.getCache();
        Assert.assertEquals((int)cache.length, (int)32);
        boolean ordered = true;
        Assert.assertTrue((boolean)inter.hasResult());
        CompactSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        rsk1 = inter.getResult(false, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
    }

    @Test
    public void checkExactIntersectionFullOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 512; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)usk1);
        inter.intersect((Sketch)usk2);
        boolean ordered = true;
        CompactSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        rsk1 = inter.getResult(false, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int i;
        int lgK = 10;
        int k = 1024;
        int u = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(1024).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(1024).build();
        for (i = 0; i < 4096; ++i) {
            usk1.update((long)i);
        }
        for (i = 2048; i < 6144; ++i) {
            usk2.update((long)i);
        }
        int memBytes = SetOperation.getMaxIntersectionBytes((int)1024);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)csk1);
        inter.intersect((Sketch)csk2);
        CompactSketch rsk1 = inter.getResult(true, null);
        DirectIntersectionTest.println("" + rsk1.getEstimate());
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkNoCall() {
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        Assert.assertFalse((boolean)inter.hasResult());
        inter.getResult(false, null);
    }

    @Test
    public void checkIntersectionNull() {
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        Sketch sk = null;
        try {
            inter.intersect(sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            inter.intersect(sk, sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void check1stCall() {
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch sk = UpdateSketch.builder().setNominalEntries(512).build();
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk);
        CompactSketch rsk1 = inter.getResult(false, null);
        double est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk = UpdateSketch.builder().setNominalEntries(512).build();
        sk.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterEmpty() {
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().build();
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.intersect((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterValid() {
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.intersect((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(2L);
        inter.intersect((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkEstimatingIntersect() {
        int i;
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1: " + sk1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        DirectIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkOverflow() {
        int lgK = 9;
        int k = 512;
        int reqBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[reqBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 2048; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1est: " + sk1.getEstimate());
        DirectIntersectionTest.println("sk1cnt: " + sk1.getRetainedEntries(true));
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
    }

    @Test
    public void checkHeapify() {
        int i;
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1: " + sk1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        DirectIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
        byte[] byteArray = inter.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)mem);
        CompactSketch comp2 = inter2.getResult(false, null);
        double est2 = comp2.getEstimate();
        DirectIntersectionTest.println("Est2: " + est2);
    }

    @Test
    public void checkPreject() {
        UpdateSketch sk = UpdateSketch.builder().setP(0.5f).build();
        sk.update(7L);
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)0);
    }

    @Test
    public void checkWrapVirginEmpty() {
        int lgK = 5;
        int k = 32;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)32);
        WritableMemory iMem = WritableMemory.writableWrap((byte[])new byte[memBytes]);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        Intersection inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdateSketch sk1 = UpdateSketch.builder().setP(0.5f).setNominalEntries(32).build();
        sk1.update(7L);
        inter1.intersect((Sketch)sk1);
        Assert.assertFalse((boolean)inter1.isEmpty());
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.isEmpty());
        Assert.assertTrue((boolean)inter2.hasResult());
        iMem = WritableMemory.writableWrap((byte[])inter1.toByteArray());
        inter2 = Sketches.wrapIntersection((Memory)iMem);
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test
    public void checkWrapNullEmpty2() {
        int lgK = 5;
        int k = 32;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)32);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        Intersection inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdateSketch sk1 = UpdateSketch.builder().setP(0.005f).setFamily(Family.QUICKSELECT).setNominalEntries(32).build();
        sk1.update(1L);
        inter1.intersect((Sketch)sk1);
        inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizeLowerLimit() {
        int k = 8;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)8);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        SetOperation.builder().buildIntersection(iMem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizedTooSmall() {
        int lgK = 5;
        int k = 32;
        int u = 128;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)16);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(32).build();
        for (int i = 0; i < 128; ++i) {
            usk1.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)csk1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        int k = 32;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)32);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        mem.putByte(0L, (byte)2);
        Sketches.wrapIntersection((WritableMemory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 32;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)32);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        mem.putByte(1L, (byte)2);
        Sketches.wrapIntersection((WritableMemory)mem);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkFamilyID() {
        int k = 32;
        Union union = SetOperation.builder().setNominalEntries(32).buildUnion();
        byte[] byteArray = union.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        Sketches.wrapIntersection((WritableMemory)mem);
    }

    @Test
    public void checkWrap() {
        int lgK = 9;
        int k = 512;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)512);
        byte[] memArr1 = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr1);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        CompactSketch compSkIn1 = sk1.compact(true, null);
        DirectIntersectionTest.println("compSkIn1: " + compSkIn1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.intersect((Sketch)compSkIn1);
        byte[] memArr2 = inter.toByteArray();
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])memArr2);
        Intersection inter2 = Sketches.wrapIntersection((WritableMemory)srcMem);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        CompactSketch compSkIn2 = sk2.compact(true, null);
        DirectIntersectionTest.println("sk2: " + compSkIn2.getEstimate());
        inter2.intersect((Sketch)compSkIn2);
        CompactSketch resultComp1 = inter2.getResult(false, null);
        double est = resultComp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
        byte[] memArr3 = inter2.toByteArray();
        WritableMemory srcMem2 = WritableMemory.writableWrap((byte[])memArr3);
        Intersection inter3 = Sketches.wrapIntersection((WritableMemory)srcMem2);
        CompactSketch resultComp2 = inter3.getResult(false, null);
        double est2 = resultComp2.getEstimate();
        DirectIntersectionTest.println("Est2: " + est2);
        inter.reset();
        inter2.reset();
        inter3.reset();
    }

    @Test
    public void checkDefaultMinSize() {
        int k = 32;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[280]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptionMinSize() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[152]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
    }

    @Test
    public void checkGetResult() {
        int k = 1024;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        int memBytes = SetOperation.getMaxIntersectionBytes((int)1024);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.writableWrap((byte[])memArr);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection(iMem);
        inter.intersect((Sketch)sk);
        CompactSketch csk = inter.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkFamily() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[280]);
        IntersectionImpl impl = IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
        Assert.assertEquals((Object)impl.getFamily(), (Object)Family.INTERSECTION);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptions1() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[280]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
        mem.putByte(1L, (byte)2);
        IntersectionImpl.wrapInstance((WritableMemory)mem, (long)9001L, (boolean)false);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptions2() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[280]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
        mem.setBits(5L, (byte)4);
        mem.putInt(8L, 2);
        IntersectionImpl.wrapInstance((WritableMemory)mem, (long)9001L, (boolean)false);
    }

    @Test
    public void checkOverlappedDirect() {
        int k = 16;
        int memBytes = 536;
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sk1.update((long)i);
            sk2.update((long)(14 + i));
        }
        WritableMemory memIn1 = WritableMemory.writableWrap((byte[])new byte[536]);
        WritableMemory memIn2 = WritableMemory.writableWrap((byte[])new byte[536]);
        WritableMemory memInter = WritableMemory.writableWrap((byte[])new byte[536]);
        WritableMemory memComp = WritableMemory.writableWrap((byte[])new byte[536]);
        CompactSketch csk1 = sk1.compact(true, memIn1);
        CompactSketch csk2 = sk2.compact(true, memIn2);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection(memInter);
        inter.intersect((Sketch)csk1);
        inter.intersect((Sketch)csk2);
        CompactSketch cskOut = inter.getResult(true, memComp);
        Assert.assertEquals((double)cskOut.getEstimate(), (double)2.0, (double)0.0);
        Intersection interRO = (Intersection)SetOperation.wrap((Memory)memInter);
        try {
            interRO.intersect((Sketch)sk1, (Sketch)sk2);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            interRO.reset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        DirectIntersectionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

