/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class UTF8Encoder$
implements Serializable {
    public static final UTF8Encoder$ MODULE$ = new UTF8Encoder$();

    private UTF8Encoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UTF8Encoder$.class);
    }

    public Seq<Object> utf8LikeEncode(String s) {
        Seq bytes = (Seq)XMLUtils$.MODULE$.walkUnicodeString(s, (Function3 & Serializable)(prev, c, next) -> UTF8Encoder$.MODULE$.utf8LikeEncoding(BoxesRunTime.unboxToChar((Object)prev), BoxesRunTime.unboxToChar((Object)c), BoxesRunTime.unboxToChar((Object)next))).flatten(Predef$.MODULE$.$conforms());
        return bytes;
    }

    public Seq<Object> byteList(Seq<Object> args) {
        return (Seq)args.map((Function1 & Serializable)_$42 -> UTF8Encoder$.byteList$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$42)));
    }

    public Seq<Object> utf8LikeEncoding(char prev, char c, char next) {
        Seq seq;
        if (prev > '\uffff') {
            throw Assert$.MODULE$.usageError("prev.<=(65535)");
        }
        if (c > '\uffff') {
            throw Assert$.MODULE$.usageError("c.<=(65535)");
        }
        if (next > '\uffff') {
            throw Assert$.MODULE$.usageError("next.<=(65535)");
        }
        char i = c;
        int byte1 = i >> 8 & 0xFF;
        int byte2 = i & 0xFF;
        char c2 = i;
        if (i <= '\u007f') {
            seq = this.byteList((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{byte2}));
        } else if (i <= '\u07ff') {
            int low6 = byte2 & 0x3F;
            int high5 = (byte1 & 7) << 2 | byte2 >> 6;
            seq = this.byteList((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{high5 | 0xC0, low6 | 0x80}));
        } else if (Character.isHighSurrogate(c)) {
            seq = Character.isLowSurrogate(next) ? this.fourByteEncode$1(c, next) : this.threeByteEncode$1(byte2, byte1);
        } else if (Character.isLowSurrogate(c)) {
            seq = Character.isHighSurrogate(prev) ? (Seq)Nil$.MODULE$ : this.threeByteEncode$1(byte2, byte1);
        } else if (i <= '\uffff') {
            seq = this.threeByteEncode$1(byte2, byte1);
        } else {
            throw Assert$.MODULE$.invariantFailed("char code out of range.");
        }
        Seq res = seq;
        return res;
    }

    private static final /* synthetic */ byte byteList$$anonfun$1(int _$42) {
        return (byte)_$42;
    }

    private final Seq threeByteEncode$1(int byte2$1, int byte1$1) {
        int low6 = byte2$1 & 0x3F;
        int mid6 = (byte1$1 & 0xF) << 2 | byte2$1 >> 6;
        int high4 = byte1$1 >> 4;
        return this.byteList((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{high4 | 0xE0, mid6 | 0x80, low6 | 0x80}));
    }

    private final Seq fourByteEncode$1(char leadingSurrogate, char trailingSurrogate) {
        char h = leadingSurrogate;
        char l = trailingSurrogate;
        int cp = 65536 + (h - 55296) * 1024 + (l - 56320);
        int byte2 = cp >> 16 & 0xFF;
        int byte3 = cp >> 8 & 0xFF;
        int byte4 = cp & 0xFF;
        int low6 = byte4 & 0x3F;
        int midlow6 = (byte3 & 0xF) << 2 | byte4 >> 6;
        int midhig6 = (byte2 & 3) << 4 | byte3 >> 4;
        int high3 = byte2 >> 2;
        return this.byteList((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{high3 | 0xF0, midhig6 | 0x80, midlow6 | 0x80, low6 | 0x80}));
    }
}

